/*
 * kernel/power/pagedir.h
 *
 * Copyright (C) 2004-2006 Nigel Cunningham <nigel@suspend2.net>
 *
 * This file is released under the GPLv2.
 *
 * Declarations for routines for handling pagesets.
 */

/* Pagedir
 *
 * Contains the metadata for a set of pages saved in the image.
 */

struct pagedir {
	long pageset_size;
	long lastpageset_size;
};

extern struct pagedir pagedir1, pagedir2;

extern void suspend_copy_pageset1(void);

extern void suspend_free_extra_pagedir_memory(void);

extern int suspend_allocate_extra_pagedir_memory(struct pagedir *p, int pageset_size, int alloc_from);

//extern void suspend_mark_task_as_pageset1 (struct task_struct *t);
extern void suspend_mark_pages_for_pageset2(void);

extern void suspend_relocate_if_required(unsigned long *current_value, unsigned int size);
extern int suspend_get_pageset1_load_addresses(void);

extern int extra_pagedir_pages_allocated;

extern unsigned long suspend_get_nonconflicting_page(void);

int suspend_protect_pageset2(void);
void suspend_restore_pageset2_permissions(void);
