/*
 * kernel/power/storage.h
 *
 * Copyright (C) 2005-2006 Nigel Cunningham <nigel@suspend2.net>
 *
 * This file is released under the GPLv2.
 */

int suspend_prepare_usm(void);
void suspend_cleanup_usm(void);

#ifdef CONFIG_NET
int suspend_activate_storage(int force);
int suspend_deactivate_storage(int force);
#else
static inline int suspend_activate_storage(int force)
{
	return 0;
}

static inline int suspend_deactivate_storage(int force)
{
	return 0;
}
#endif

enum {
	USM_MSG_BASE = 0x10,

	/* Kernel -> Userspace */
	USM_MSG_CONNECT = 0x30,
	USM_MSG_DISCONNECT = 0x31,
	USM_MSG_SUCCESS = 0x40,
	USM_MSG_FAILED = 0x41,

	USM_MSG_MAX,
};
