#ifndef _LINUX_SWSUSP_H
#define _LINUX_SWSUSP_H

#if defined(CONFIG_X86) || defined(CONFIG_FRV) || defined(CONFIG_PPC32)
#include <asm/suspend.h>
#endif
#include <linux/swap.h>
#include <linux/notifier.h>
#include <linux/init.h>
#include <linux/pm.h>

/* struct pbe is used for creating lists of pages that should be restored
 * atomically during the resume from disk, because the page frames they have
 * occupied before the suspend are in use.
 */
struct pbe {
	void *address;		/* address of the copy */
	void *orig_address;	/* original address of a page */
	struct pbe *next;
};

/* mm/page_alloc.c */
extern void drain_local_pages(void);
extern void mark_free_pages(struct zone *zone);

#ifdef CONFIG_PM
/* kernel/power/swsusp.c */
extern int software_suspend(void);

extern int pm_prepare_console(void);
extern void pm_restore_console(void);
#else
static inline int software_suspend(void)
{
	printk("Warning: fake suspend called\n");
	return -ENOSYS;
}
#endif /* CONFIG_PM */

void save_processor_state(void);
void restore_processor_state(void);
struct saved_context;
unsigned long get_safe_page(gfp_t gfp_mask);

/*
 * XXX: We try to keep some more pages free so that I/O operations succeed
 * without paging. Might this be more?
 */
#define PAGES_FOR_IO	1024

enum {
	SUSPEND_CAN_SUSPEND,
	SUSPEND_CAN_RESUME,
	SUSPEND_RUNNING,
	SUSPEND_RESUME_DEVICE_OK,
	SUSPEND_NORESUME_SPECIFIED,
	SUSPEND_SANITY_CHECK_PROMPT,
	SUSPEND_PAGESET2_NOT_LOADED,
	SUSPEND_CONTINUE_REQ,
	SUSPEND_RESUMED_BEFORE,
	SUSPEND_RESUME_NOT_DONE,
	SUSPEND_BOOT_TIME,
	SUSPEND_NOW_RESUMING,
	SUSPEND_IGNORE_LOGLEVEL,
	SUSPEND_TRYING_TO_RESUME,
	SUSPEND_TRY_RESUME_RD,
	SUSPEND_LOADING_ALT_IMAGE,
	SUSPEND_STOP_RESUME,
	SUSPEND_IO_STOPPED,
};

#ifdef CONFIG_SUSPEND2

/* Used in init dir files */
extern unsigned long suspend_state;
#define set_suspend_state(bit) (set_bit(bit, &suspend_state))
#define clear_suspend_state(bit) (clear_bit(bit, &suspend_state))
#define test_suspend_state(bit) (test_bit(bit, &suspend_state))
extern int suspend2_running;

#else /* !CONFIG_SUSPEND2 */

#define suspend_state		(0)
#define set_suspend_state(bit) do { } while(0)
#define clear_suspend_state(bit) do { } while (0)
#define test_suspend_state(bit) (0)
#define suspend2_running (0)
#endif /* CONFIG_SUSPEND2 */

#ifdef CONFIG_SUSPEND_SHARED
#ifdef CONFIG_SUSPEND2
extern void suspend2_try_resume(void);
#else
#define suspend2_try_resume() do { } while(0)
#endif

extern int resume_attempted;

#ifdef CONFIG_SOFTWARE_SUSPEND
extern int software_resume(void);
#else
static inline int software_resume(void)
{
	resume_attempted = 1;
	suspend2_try_resume();
	return 0;
}
#endif

static inline void check_resume_attempted(void)
{
	if (resume_attempted)
		return;

	software_resume();
}
#else
#define check_resume_attempted() do { } while(0)
#define resume_attempted (0)
#endif

#ifdef CONFIG_PRINTK_NOSAVE
#define POSS_NOSAVE __nosavedata
#else
#define POSS_NOSAVE
#endif

#endif /* _LINUX_SWSUSP_H */
