static char *IMAGE_C="\n#define FILTER_MAIN 1\n\n\n#ifdef TEST\n#include <stdio.h>\n#include <math.h>\n#define IMFILTRTN _FilterImage\n#define NMASK 0\n#define MASKDIM 0\n#define _masks NULL\n#define TEST5\n\n#ifdef TEST5\n#define NSHAPE 1\n#define NREGION 1\n#define FILTER ((imcircle(g,1,1,1,4,(double)x,(double)y,1.0,1.0,1.0)))\n#define FILTSTR \"((imcircle(g,1,1,1,4,(double)x,(double)y,1.0,1.0,1.0)))\"\n#define FINIT imcirclei(g,1,1,1,4,(double)x,(double)y,1.0,1.0,1.0);\n#endif\n\n#ifdef TEST4\n#define NSHAPE 8\n#define NREGION 4\n#define FILTER ((impanda(g,1,1,1,4,(double)x,(double)y,8.0,8.0,0.0,20.0,2.0,0.0,5.0,2.0)))\n#define FILTSTR \"((impanda(g,1,1,1,4,(double)x,(double)y,8.0,8.0,0.0,20.0,2.0,0.0,5.0,2.0)))\"\n#define FINIT impandai(g,1,1,1,4,(double)x,(double)y,8.0,8.0,0.0,20.0,2.0,0.0,5.0,2.0);\n#endif\n\n#ifdef TEST3\n#define NSHAPE 1\n#define NREGION 1\n#define FILTER ((imannulus(g,1,1,1,4,(double)x,(double)y,2.5,2.1,1.0,2.0)))\n#define FILTSTR \"((imannulus(g,1,1,1,4,(double)x,(double)y,2.5,2.1,1.0,2.0)))\"\n#define FINIT imannulusi(g,1,1,1,4,(double)x,(double)y,2.5,2.1,1.0,2.0);\n#endif\n\n#ifdef TEST2\n#define NSHAPE 2\n#define NREGION 2\n#define FILTER ((imannulus(g,1,1,1,4,(double)x,(double)y,2.5,2.1,0.0,1.0))||(imannulus(g,2,2,1,4,(double)x,(double)y,2.5,2.1,1.0,1.5)))\n#define FILTSTR \"((imannulus(g,1,1,1,4,(double)x,(double)y,2.5,2.1,0.0,1.0))||(imannulus(g,2,2,1,4,(double)x,(double)y,2.5,2.1,1.0,1.5)))\"\n#define FINIT imannulusi(g,1,1,1,4,(double)x,(double)y,2.5,2.1,0.0,1.0);imannulusi(g,2,2,1,4,(double)x,(double)y,2.5,2.1,1.0,1.5);\n#endif\n\n#ifdef TEST1\n#define NSHAPE 2\n#define NREGION 2\n#define FILTER ((imfield(g,1,1,1,4,(double)x,(double)y)))&&(imcircle(g,2,2,0,1,(double)x,(double)y,7.0,7.0,2.0))\n#define FILTSTR \"((imfield(g,1,1,1,4,(double)x,(double)y)))&&(imcircle(g,2,2,0,1,(double)x,(double)y,7.0,7.0,2.0))\"\n#define FINIT imfieldi(g,1,1,1,4,(double)x,(double)y);imcirclei(g,2,2,0,1,(double)x,(double)y,7.0,7.0,2.0);\n#endif\n\n#ifdef TEST0\n#define NSHAPE 2\n#define NREGION 2\n#define FILTER ((imcircle(g,1,1,1,4,(double)x,(double)y,8.0,8.0,5.0)))&&(imcircle(g,2,2,0,1,(double)x,(double)y,8.0,8.0,3.0))\n#define FILTSTR \"((imcircle(g,1,1,1,4,(double)x,(double)y,8.0,8.0,5.0)))&&(imcircle(g,2,2,0,1,(double)x,(double)y,8.0,8.0,3.0))\"\n#define FINIT imcirclei(g,1,1,1,4,(double)x,(double)y,8.0,8.0,5.0);imcirclei(g,2,2,0,1,(double)x,(double)y,8.0,8.0,3.0);\n#endif\n\n#include \"regions.h\"\n#endif\n\n\nFilterMask masks=NULL;		\nint maxmask;			\nint nmask;			\nint nreg;			\nint rid;			\nint x, y;			\nint rlen;			\nint *rbuf;			\nint *rptr;			\n\nvoid incnmask(void)\n{\n  int omax;\n  nmask++;\n  if( nmask >= maxmask ){\n    omax = maxmask;\n    maxmask += MASKINC;\n    masks = (FilterMask)realloc(masks, maxmask*sizeof(FilterMaskRec));\n    memset(masks+omax, 0, (maxmask-omax)*sizeof(FilterMaskRec));\n  }\n}\n\nFilterMask\nIMFILTRTN(int txmin, int txmax, int tymin, int tymax, int tblock, int *got)\n{\n  int i, j;\n  int fieldonly;\n  GFilt g;\n  Scan scan, tscan;\n\n  \n  if( NSHAPE <=0 ){\n    *got = 0;\n    return NULL;\n  }\n  \n  g = (GFilt)calloc(1, sizeof(GFiltRec));\n  \n  fieldonly = (NSHAPE==1) && strstr(FILTSTR, \"field\");\n  \n  g->nshapes = NSHAPE;\n  g->maxshapes = (NSHAPE*(XSNO+1))+1;\n  g->shapes = (Shape)calloc(g->maxshapes, sizeof(ShapeRec));\n  \n  g->block= max(1,tblock);\n  g->xmin = max(1,txmin); \n  g->xmax = txmax;\n  g->ymin = max(1,tymin);\n  g->ymax = tymax;\n  \n  g->x0 = 1;\n  g->y0 = 1;\n  g->x1 = (g->xmax-g->xmin)/g->block+1;\n  g->y1 = (g->ymax-g->ymin)/g->block+1;\n  \n  rlen = g->x1 - g->x0 + 1;\n  rbuf = (int *)calloc(rlen+1, sizeof(int));\n  \n  maxmask = MASKINC;\n  masks = (FilterMask)calloc(maxmask, sizeof(FilterMaskRec));\n  \n  nmask = 0;\n  masks[nmask].region = 0;\n  \n  nreg = 0;\n  \n  g->ybuf = (int *)calloc(g->y1+1, sizeof(int));\n  g->x0s = (int *)calloc(g->y1+1, sizeof(int));\n  g->x1s = (int *)calloc(g->y1+1, sizeof(int));\n  \n  for(i=0; i<=g->y1; i++) g->x0s[i]  = g->x1;\n  for(i=0; i<=g->y1; i++) g->x1s[i]  = g->x0;\n  \n  if( NMASK ){\n    g->nmask = NMASK; \n    g->maskdim = MASKDIM;\n    g->masks = _masks;\n  }\n  \n  FINIT;\n  \n  for(y=g->y0; y<=g->y1; y++){\n    if( fieldonly ){\n      \n      masks[nmask].region = 1;\n      masks[nmask].y = y - g->y0 + 1;\n      masks[nmask].xstart = 1;\n      masks[nmask].xstop = (g->x1 - g->x0 + 1);\n      incnmask();\n      continue;\n    }\n    if( g->ybuf[y] ){\n      \n      if( masks[nmask].region ){\n	\n	incnmask();\n	masks[nmask].region = 0;\n      }\n      \n      for(x=g->x0s[y], rptr=&rbuf[1+(g->x0s[y]-g->x0)]; x<=g->x1s[y];\n	  x++, rptr++){\n	\n	g->rid = 0;\n	if( FILTER ){\n	  \n	  if( *rptr == 0 ){\n	    nreg++;\n	    *rptr = g->rid ? g->rid : -1;\n	  }\n	  \n	  else if( (*rptr == -1) && (g->rid >0) ){\n	    *rptr = g->rid;\n	  }\n	}\n      }\n    }\n    \n    if( nreg ){\n      for(i=1; i<=rlen; i++){\n	if( rbuf[i] != masks[nmask].region ){\n	  \n	  if( masks[nmask].region ){\n	    masks[nmask].xstop = i - 1;\n	    \n	    incnmask();\n	  }\n	  masks[nmask].y = y - g->y0 + 1;\n	  masks[nmask].region = rbuf[i];\n	  masks[nmask].xstart = i;\n	}\n      }\n      \n      if( masks[nmask].region ){\n	masks[nmask].xstop = (g->x1 - g->x0 + 1);\n	\n	incnmask();\n      }\n      \n      (void)memset(rbuf, 0, (rlen+1)*sizeof(int));\n      rptr = rbuf;\n      nreg = 0;\n    }\n  }\n  \n  if( rbuf) free(rbuf);\n  \n  if( g ){\n    for(i=0; i<g->maxshapes; i++){\n      if( g->shapes[i].scanlist ){\n	for(j=0; j<=g->y1; j++){\n	  if( g->shapes[i].scanlist[j] ){\n	    for(scan=g->shapes[i].scanlist[j]; scan; ){\n	      tscan = scan->next;\n	      free(scan);\n	      scan = tscan;\n	    }\n	  }\n	}\n	free(g->shapes[i].scanlist);\n      }\n      if( g->shapes[i].pts ) free(g->shapes[i].pts);\n      if( g->shapes[i].xv ) free(g->shapes[i].xv);\n    }\n    if( g->masks )  free(g->masks);\n    if( g->shapes ) free(g->shapes);\n    if( g->ybuf )   free(g->ybuf);\n    if( g->x0s )    free(g->x0s);\n    if( g->x1s )    free(g->x1s);\n    if( g )         free(g);\n  }\n  \n  *got = nmask;\n  return masks;\n}\n\n\n#ifdef FILTER_MAIN\nint main(int argc, char **argv)\n{\n#ifdef TEST\n  int i;\n#endif\n  int get;\n  int got;\n  int txmin, txmax, tymin, tymax, tblock;\n  char tbuf[SZ_LINE];\n\n  \n#ifdef TEST\n  while( fgets(tbuf, SZ_LINE, stdin) ){\n#else\n  while( (read(0, &get, sizeof(int)) >0) && (read(0, tbuf, get)==get) ){\n#endif\n    if(sscanf(tbuf, \"%d %d %d %d %d\",\n	      &txmin, &txmax, &tymin, &tymax, &tblock)!=5){\n      break;\n    }\n    masks = IMFILTRTN(txmin, txmax, tymin, tymax, tblock, &got);\n#ifdef TEST\n    \n    fprintf(stdout, \"nmask=%d\\n\", nmask);\n    for(i=0; i<nmask; i++){\n      fprintf(stdout, \"region: %d\tx: (%d,%d)\ty: %d\\n\",\n	      masks[i].region, masks[i].xstart, masks[i].xstop, masks[i].y);\n    }\n    fflush(stdout);\n#else\n    \n    got =  got * sizeof(FilterMaskRec);\n    write(1, &got, 4);\n    write(1, masks, got);\n#endif\n    \n    if( masks ) free(masks);\n  }\n#ifndef TEST\n  unlink(argv[0]);\n#endif\n}\n#endif\n";
