#!/bin/sh

export PATH
PATH="/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin:\
/opt/bin:/opt/sbin:/opt/local/bin:/opt/local/sbin:\
/usr/samba/bin:/usr/samba/sbin:/usr/local/samba/bin:/usr/local/samba/sbin:\
/opt/samba/bin:/opt/samba/sbin:/opt/local/samba/bin:/opt/local/samba/sbin"

check_cmd ()
{
    echo -n "checking $1..."
    cmd_var=@`echo $1 | tr a-z A-Z`@
    cmd_path=`which $1`

    if [ -f "$cmd_path" ]; then
	echo "$cmd_path"
	echo "s:$cmd_var:$cmd_path:" >> config.sed
    elif [ -n "$2" ]; then
	echo "not found(ignored)"
	echo "s:$cmd_var:$2/$1:" >> config.sed
    else
	echo "not found"
	exit 1
    fi
}

commands="grep sed awk perl basename md5sum ifconfig route ping \
ifport:/sbin ifuser:/sbin mii-tool:/sbin \
smbd:/usr/local/samba/sbin nmbd:/usr/local/samba/sbin \
dhclient:/sbin iwconfig:/sbin iwspy:/sbin iwpriv:/sbin"

rm -f config.sed > /dev/null 2>&1

for c in $commands; do
    cmd=`expr $c : '\([^:]*\)'`
    dir=`expr $c : '[^:]*:\(.*\)'`
    check_cmd $cmd $dir
done

AGENTDIR=${AGENTDIR:-/sbin}

for cmd in ifup ifdown; do
    cmd_var=@`echo $cmd | tr a-z A-Z`@
    echo "s:$cmd_var:$AGENTDIR/$cmd:" >> config.sed
done

RCDIR=${RCDIR:-/etc/rc.d}

echo "s:@RCDIR@:$RCDIR:" >> config.sed

echo "s:@_NOROOT_@/::" >> config.sed

exit 0
