/*
  beep.c: Play a beep
  Author: Shun-ichi TAHARA <jado@flowernet.gr.jp>
  Time-stamp: <03/06/15 11:45:11 jado@sheira>

  Copyright (c) 2003 Shun-ichi TAHARA
*/

#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/kd.h>

int beep(int length, int freq)
{
    int fd;
    struct timeval tv;

    if ((fd = open("/dev/console", O_RDWR)) < 0)
	return -1;

    if (ioctl(fd, KDMKTONE, length << 16 | freq)) {
	close(fd);
	return -1;
    }
    tv.tv_sec = 0;
    tv.tv_usec = length * 1000;
    select(0, NULL, NULL, NULL, &tv);

    close(fd);
    return 0;
}
