/*
  daemon.c: Processes about daemons
  Author: Shun-ichi TAHARA <jado@flowernet.gr.jp>
  Time-stamp: <03/06/16 13:37:04 jado@sheira>

  Copyright (c) 2003 Shun-ichi TAHARA
*/

#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <fcntl.h>

#include "lockfile.h"
#include "log.h"

void reopen_stdio(void)
{
    int fd;

    while ((fd = open("/dev/null", O_RDWR)) >= 0 && fd < 2)
	;
    if (fd > 2)
	close(fd);
}

int daemonize(char *device, char *hwaddr)
{
    pid_t pid;

    if ((pid = fork()) < 0) {
	error_log("daemonize: fork");
	clean_lockfile();
	exit(1);
    } else if (pid) {
	exit(0);
    }

    if (lock_daemon())
	return -1;

    pid = setsid();
    init_log(1);
    set_pid(pid, hwaddr);

    /* Close standard I/Os' and reopen them */
    close(0);
    close(1);
    close(2);
    reopen_stdio();

    return 0;
}

int kill_daemon(int sig)
{
    pid_t pid;

    if ((pid = get_pid()) < 0)
	return -1;

    return kill(pid, sig);
}
