/*
  ifctl: Control network interface for netscript
  Author: Shun-ichi TAHARA <jado@flowernet.gr.jp>
  Time-stamp: <03/06/15 09:16:16 jado@sheira>

  Copyright (c) 2002 Shun-ichi TAHARA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#include "cmdname.h"
#include "daemon.h"
#include "lockfile.h"
#include "log.h"

void usage(void)
{
    fprintf(stderr, "Usage: %s device {up|down|toggle}\n", cmdname);
    exit(0);
}

int main(int argc, char **argv)
{
    char *device;
    int sig = SIGUNUSED;
    int status;

    /* Standard I/Os' may be closed */
    reopen_stdio();
    set_cmdname(*argv);

    if (argc != 3)
	usage();

    device = argv[1];
    set_lockfile(device);

    if (!strcmp(argv[2], "up")) {
	sig = SIGUSR1;
    } else if (!strcmp(argv[2], "down")) {
	sig = SIGUSR2;
    } else if (!strcmp(argv[2], "toggle")) {
	if ((status = test_device(1)) < 0) {
	    print_log("%s: device not started.", device);
	    exit(1);
	}
	sig = (!status) ? SIGUSR1 : SIGUSR2;
    } else {
	usage();
    }

    if (kill_daemon(sig)) {
	print_log("%s: device not started.", device);
	exit(1);
    }

    exit(0);
}
