/*
  ifdown: Stop network interface for netscript
  Author: Shun-ichi TAHARA <jado@flowernet.gr.jp>
  Time-stamp: <03/06/15 11:14:22 jado@sheira>

  Copyright (c) 2002 Shun-ichi TAHARA
*/

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include "cmdname.h"
#include "daemon.h"
#include "lockfile.h"
#include "log.h"
#include "netif.h"

void usage(void)
{
    fprintf(stderr, "Usage: %s device\n", cmdname);
    exit(0);
}

int main(int argc, char **argv)
{
    char *device;

    /* SIGCHLD may be set to SIG_IGN */
    signal(SIGCHLD, SIG_DFL);
    /* Standard I/Os' may be closed */
    reopen_stdio();
    set_cmdname(*argv);

    if (argc != 2)
	usage();

    init_log(0);
    set_lockfile(device = argv[1]);

    if (kill_daemon(SIGTERM)) {
	/* Cannot stop ifctld */
	print_log("%s: device not started.", device);

	clean_lockfile();
	exit(1);
    }

    init_log(1);
    disable_if(device, 1);
    clean_lockfile();
    exit(0);
}
