/*
  ifup: Start network interface for netscript
  Author: Shun-ichi TAHARA <jado@flowernet.gr.jp>
  Time-stamp: <03/06/11 00:32:38 jado@sheira>

  Copyright (c) 2002 Shun-ichi TAHARA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#include "defines.h"
#include "cmdname.h"
#include "daemon.h"
#include "log.h"

typedef enum {
    MODE_UNKNOWN = -1,
    MODE_STATIC = 0,
    MODE_DYNAMIC,
    MODE_MANUAL
} devmode_t;

char *mode_name[] = {
    "static", "dynamic", "manual"
};

char *mode_opt[] = {
    "-s", "-d", "-m"
};

devmode_t get_mode(char *device)
{
    FILE *fp;
    char buf[256];
    char *p, *q;

    if ((fp = fopen(MODFILE, "r")) == NULL)
	return MODE_STATIC;	/* Default */

    while (fgets(p = buf, 256, fp) != NULL) {
	while (isspace(*p))
	    p++;
	if (*p == '#')
	    goto Next;
	q = p;
	while (!isspace(*p)) {
	    if (!*p || *p == '\n')
		goto Next;
	    p++;
	}
	*p++ = '\0';
	if (strcmp(q, device))
	    continue;
	while (isspace(*p))
	    p++;
	if (*p++ != '-')
	    goto Next;
	switch (*p) {
	case 's':
	    return MODE_STATIC;
	case 'd':
	    return MODE_DYNAMIC;
	case 'm':
	    return MODE_MANUAL;
	}
    Next:
    }

    fclose(fp);
    return MODE_STATIC;	/* Default */
}

void usage(void)
{
    fprintf(stderr, "Usage: %s [-v] [-s|-d|-m] device\n", cmdname);
    exit(0);
}

int main(int argc, char **argv)
{
    int i;
    char *p;
    char *device = NULL;
    devmode_t mode = MODE_UNKNOWN;
    int verbose = 0;

    /* Standard I/Os' may be closed */
    reopen_stdio();
    set_cmdname(*argv);

    for (i = 1; i < argc; i++) {
	p = argv[i];
	if (*p == '-') {
	    while (*(++p)) {
		switch (*p) {
		case 's':
		    mode = MODE_STATIC;
		    break;
		case 'd':
		    mode = MODE_DYNAMIC;
		    break;
		case 'm':
		    mode = MODE_MANUAL;
		    break;
		case 'v':
		    verbose = 1;
		    break;
		default:
		    usage();
		}
	    }
	} else if (device == NULL) {
	    device = p;
	} else {
	    usage();
	}
    }
    if (device == NULL)
	usage();

    if (mode == MODE_UNKNOWN)
	mode = get_mode(device);

    if (verbose)
	printf("Starting interface: %s - %s.\n", device, mode_name[mode]);

    execl(AGENTDIR "/ifctld", "ifctld", mode_opt[mode], device, NULL);

    init_log(0);
    error_log(AGENTDIR "/ifctld");
    exit(1);
}
