/*
  ioctl.c: ioctl functions for netscript
  Author: Shun-ichi TAHARA <jado@flowernet.gr.jp>
  Time-stamp: <03/06/16 13:37:38 jado@sheira>

  Copyright (c) 2003 Shun-ichi TAHARA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>

#include "log.h"

#define IFREQ_DATA(ifr,ofs) *((unsigned short *)(&((ifr)->ifr_data)) + (ofs))

static int ioctl_base;

/* Initialize ifreq for ioctl */

int init_ifreq(char *ifname, struct ifreq *ifr)
{
    int sock;

    if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
	error_log("init_ifreq: socket");
	exit(1);
    }
    strncpy(ifr->ifr_name, ifname, IFNAMSIZ);

    return sock;
}

/* Get HW address */

char *get_hwaddr(int sock, struct ifreq *ifr)
{
    int i;
    char *buf, *p;
    unsigned char *q;

    if (ioctl(sock, SIOCGIFHWADDR, ifr) < 0)
	return NULL;

    if ((p = buf = (char *)malloc(IFHWADDRLEN * 3)) == NULL) {
	error_log("get_hwaddr: malloc");
	exit(1);
    }
    q = (unsigned char *)(&(ifr->ifr_hwaddr.sa_data));
    for (i = 0; i < IFHWADDRLEN; i++) {
	sprintf(p, "%02X:", *q++);
	p += 3;
    }
    *(p - 1) = '\0';

    return buf;
}

/* Watch link status */

int mdio_init(int sock, struct ifreq *ifr)
{
    IFREQ_DATA(ifr, 0) = 0;

    if (ioctl(sock, 0x8947, ifr) >= 0)
	ioctl_base = 0x8947;
    else if (ioctl(sock, SIOCDEVPRIVATE, ifr) >= 0)
	ioctl_base = SIOCDEVPRIVATE;
    else
	return -1;

    return IFREQ_DATA(ifr, 0);
}

int mdio_read(int sock, struct ifreq *ifr, int phyid, int offset)
{
    IFREQ_DATA(ifr, 0) = phyid;
    IFREQ_DATA(ifr, 1) = offset;

    if (ioctl(sock, ioctl_base + 1, ifr) < 0) {
	if (errno != ENODEV) {
	    error_log("mdio_read: SIOCGMIIREG");
	    exit(1);
	}
	return -1;
    }

    return IFREQ_DATA(ifr, 3);
}
