/*
  log.c: Handle logs
  Author: Shun-ichi TAHARA <jado@flowernet.gr.jp>
  Time-stamp: <03/06/14 10:39:40 jado@sheira>

  Copyright (c) 2003 Shun-ichi TAHARA
*/

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdarg.h>
#include <syslog.h>

#include "cmdname.h"

static int enable_stderr = 1;
static int enable_syslog = 0;

void init_log(int daemon)
{
    enable_stderr = !daemon;

    if (!enable_syslog) {
	enable_syslog = 1;
	openlog(cmdname, LOG_PID, LOG_DAEMON);
    }
}

void print_log(char *fmt, ...)
{
    va_list ap;

    if (enable_stderr) {
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	fputc('\n', stderr);
    }

    if (enable_syslog) {
	va_start(ap, fmt);
	vsyslog(LOG_INFO, fmt, ap);
	va_end(ap);
    }
}

void error_log(char *s)
{
    int save_errno = errno;

    if (enable_stderr)
	perror(s);

    if (enable_syslog)
	syslog(LOG_ERR, "%s: %s\n", s, strerror(save_errno));
}
