/*
  strarray.c: Handle string array
  Author: Shun-ichi TAHARA <jado@flowernet.gr.jp>
  Time-stamp: <03/06/16 13:43:56 jado@sheira>

  Copyright (c) 2003 Shun-ichi TAHARA
*/

#include <stdlib.h>
#include <string.h>

#include "log.h"

int strary_len(char **array)
{
    int n;
    char **p;

    if (array == NULL)
	return 0;

    for (p = array, n = 0; *p != NULL; p++, n++)
	;

    return n;
}

char **strary_append(char **array, char *str, int dup)
{
    int n;
    char **p;

    n = strary_len(array);

    if (!dup && n > 0) {
	for (p = array; *p != NULL; p++) {
	    if (!strcmp(*p, str))
		break;
	}
	if (*p != NULL)
	    return array;
    }

    if ((array = (char **)realloc(array, sizeof(char *) * (n + 2))) == NULL) {
	error_log("strary_append: realloc");
	exit(1);
    }

    if ((array[n] = strdup(str)) == NULL) {
	error_log("strary_append: strdup");
	exit(1);
    }
    array[n + 1] = NULL;

    return array;
}

void strary_free(char **array)
{
    char **p;

    if (array == NULL)
	return;

    for (p = array; *p != NULL; p++)
	free(*p);

    free(array);
}
