#!/bin/sh

SWNAME=tiff-v3.5.7
BUILD_ROOT=`pwd`/pkg

rm -rf pkg
mkdir -p pkg/usr/man/man1
mkdir -p pkg/usr/man/man3
mkdir -p pkg/usr/lib
mkdir -p pkg/usr/bin
mkdir -p pkg/usr/include
mkdir -p pkg/usr/doc/$SWNAME/html

rm -rf libtiff-lzw-compression-kit-1.3
tar zxvf libtiff-lzw-compression-kit-1.3.tar.gz

rm -rf $SWNAME
tar zxvf $SWNAME.tar.gz

cat libtiff-lzw-compression-kit-1.3/tif_lzw.c > ${SWNAME}/libtiff/tif_lzw.c

cd $SWNAME
patch -p1 <../tiff-v3.5-shlib.patch
patch -p1 <../libtiff-v3.4-arm.patch
patch -p1 <../libtiff-v3.5.4-codecs.patch
patch -p1 <../libtiff-v3.5.4-mandir.patch
patch -p1 <../libtiff-v3.5.5-64bit.patch
patch -p1 <../libtiff-v3.5.7-seek.patch
patch -p1 <../libtiff-v3.5.7-exit.patch

patch -p1 <../libtiff-v3.5.7-largefile.patch
patch -p1 <../libtiff-v3.5.7-makeflags.patch
patch -p1 <../libtiff-3.5.7-alt-bound.patch
patch -p1 <../libtiff-3.5.7-up-ChopUpSingleUncompressedStrip.patch
patch -p1 <../libtiff-3.5.7-chris-bound.patch
patch -p1 <../libtiff-3.5.7-alt-bound2.patch
patch -p0 <../libtiff-3.5.7-unsupported-codecs.patch

patch -p1 <<EOF
--- tiff-v3.5.5/port/install.sh.in	Thu May 18 18:40:04 2000
+++ tiff-v3.5.5/port/install.sh.in	Thu May 18 18:40:26 2000
@@ -92,6 +92,7 @@
 VERBOSE=":"
 STRIP="@STRIP@"
 CMP=cmp
+ROOT=$BUILD_ROOT
 
 TARGETS=
 while [ x"\$1" != x ]
EOF

./configure --target=i386-linux --with-GCOPTS=" " << EOF
no
/usr/bin
/usr/lib
/usr/include
/usr/man
/usr/doc/$SWNAME/html
bsd-source-cat
yes
EOF

make
make install

gzip ../pkg/usr/man/man?/*
cp -pR html ../pkg/usr/doc/$SWNAME/.
cp -p ../PlamoBuild.sh COPYRIGHT README RELEASE-DATE TODO VERSION ../pkg/usr/doc/$SWNAME/.
gzip ../pkg/usr/doc/$SWNAME/PlamoBuild.sh
gzip ../pkg/usr/doc/$SWNAME/C*
gzip ../pkg/usr/doc/$SWNAME/R*
gzip ../pkg/usr/doc/$SWNAME/T*
gzip ../pkg/usr/doc/$SWNAME/V*
chown -R root:root ../pkg/usr/doc

# for Plamo-4.x
mkdir -p ../pkg/usr/share
mv ../pkg/usr/doc ../pkg/usr/share/.
mv ../pkg/usr/man ../pkg/usr/share/.

