#!/bin/sh

SWNAME=jpeg-6b

rm -rf $SWNAME
tar zxvf jpegsrc.v6b.tar.gz
cd $SWNAME
patch -p1 < ../libjpeg-6b-arm.patch
patch -p1 < ../jpeg-c++.patch
./configure --prefix=/usr --enable-shared --enable-static
make

rm -rf ../pkg
mkdir -p ../pkg/usr/include
mkdir -p ../pkg/usr/lib
mkdir -p ../pkg/usr/bin
mkdir -p ../pkg/usr/man/man1
make install prefix=`pwd`/../pkg/usr
gzip ../pkg/usr/man/man?/*

mkdir -p ../pkg/usr/doc/$SWNAME
cp -p ../plamobuild.sh README change.log *.doc ../pkg/usr/doc/$SWNAME/.
gzip ../pkg/usr/doc/$SWNAME/*
cp -p *.jpg ../pkg/usr/doc/$SWNAME/.
chown -R root:root ../pkg/usr/doc
