#!/bin/sh

SWVERSION=1.7.2
SWNAME=mozilla-${SWVERSION}
DOCDIR=/usr/share/doc
MANDIR=/usr/share/man

P=`pwd`/pkg
rm -rf $P
mkdir -p $P

cd mozilla
BUILD_OFFICIAL=1 MOZILLA_OFFICIAL=1 make install DESTDIR=$P
cd ..

rm -r JLP
mkdir JLP
cd JLP
 ln -s ../moz1.7-langjajp-tm0.2.xpi .
 unzip moz1.7-langjajp-tm0.2.xpi
 pushd bin
   tar cf - . | ( cd ${P}/usr/lib/mozilla-${SWVERSION} ; tar xf - )
 popd
cd ..

cp -p JLP/sp*/* ${P}/usr/lib/mozilla-${SWVERSION}/searchplugins/
chown -R root:root ${P}/usr/lib/mozilla-${SWVERSION}/searchplugins

pushd ${P}/usr/lib/mozilla-${SWVERSION}/chrome
  /bin/sh ${P}/../locale-reg.sh ja-JP.jar ja-unix.jar JP.jar \
        >> installed-chrome.txt
  cat << EOF >> installed-chrome.txt
locale,install,select,ja-JP
locale,install,select,JP
skin,install,select,classic/1.0
EOF
popd

pushd ${P}/usr/lib/mozilla-${SWVERSION}
cat <<EOF > defaults/profile/JP/prefs.js
# Mozilla User Preferences
// This is a generated file!

user_pref("browser.startup.homepage", "http://plamo-linux.jp/");
user_pref("startup.homepage_override_url", "http://plamo-linux.jp/plamo-4.0.html");
user_pref("font.default", "sans-serif");
user_pref("font.name.cursive.ja", "alias-serif-jisx0208.1983-0");
user_pref("font.name.fantasy.ja", "alias-serif-jisx0208.1983-0");
user_pref("font.name.monospace.ja", "alias-monospace-jisx0208.1983-0");
user_pref("font.name.sans-serif.ja", "alias-sans-jisx0208.1983-0");
user_pref("font.name.serif.ja", "alias-serif-jisx0208.1983-0");
user_pref("xim.input_style", "over-the-spot");
EOF
popd

gzip ${P}${MANDIR}/man1/mozilla.1

mkdir -p ${P}${DOCDIR}/${SWNAME}
cp -p mozilla/LICENSE ${P}${DOCDIR}/${SWNAME}/.
cp -p mozilla/LEGAL ${P}${DOCDIR}/${SWNAME}/.
cp -p mozilla/README.txt ${P}${DOCDIR}/${SWNAME}/.
chown -R root:root ${P}${DOCDIR}
