#!/bin/sh

MANDIR=/usr/share/man

rm -rf mozilla
bzcat mozilla-source-1.7.2.tar.bz2 | tar xf -

cd mozilla
# security update for 1.7.1
#patch -p0 < ../mozilla-1.7.1-certificate_spoof.patch
#patch -p0 < ../mozilla-1.7-fix-null_fakes_extension.patch
#patch -p0 < ../mozilla-1.7-fix-libpng_overflow.patch
#patch -p1 < ../mozilla-1.7-fix-CA_certificate.patch

# fix traditional bug
pushd gfx/src/gtk
patch < ../../../../mozilla-0.9.9-fontfix.patch
popd

patch -p1 < ../mozilla-1.7-psfonts.patch
patch -p0 < ../mozilla-1.1-sjisalias.patch
patch -p1 < ../mozilla-plamo-home-page.patch
patch -p1 <<EOF
--- mozilla/xpfe/browser/resources/locale/en-US/region.properties.foo	Thu Aug  1 20:53:34 2002
+++ mozilla/xpfe/browser/resources/locale/en-US/region.properties	Thu Aug  1 20:53:34 2004
@@ -21,4 +21,4 @@
 
 #config.js
 #
-startup.homepage_override_url=http://www.mozilla.org/start/
+startup.homepage_override_url=http://plamo-linux.jp/plamo-4.0.html
EOF

BUILD_OFFICIAL=1 MOZILLA_OFFICIAL=1 ./configure --prefix=/usr --mandir=$MANDIR --enable-optimize=-O2 --enable-strip --disable-debug --disable-debug-modules --disable-tests --enable-crypto --disable-freetype2 --disable-xft
## --with-system-png 
BUILD_OFFICIAL=1 MOZILLA_OFFICIAL=1 make

