% File src/library/datasets/man/Indometh.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2007 R Core Development Team
% Distributed under GPL 2 or later

\name{Indometh}
\docType{data}
\alias{Indometh}
\title{Pharmacokinetics of Indomethicin}
\description{
  The \code{Indometh} data frame has 66 rows and 3 columns of data on
  the pharmacokinetics of indomethicin.
}
\usage{Indometh}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Subject}{
      an ordered factor with containing the subject codes.  The
      ordering is according to increasing maximum response.
    }
    \item{time}{
      a numeric vector of times at which blood samples were drawn (hr).
    }
    \item{conc}{
      a numeric vector of plasma concentrations of indomethicin (mcg/ml).
    }
  }
}
\details{
  Each of the six subjects were given an intravenous injection of
  indomethicin.
}
\source{
  Kwan, Breault, Umbenhauer, McMahon and Duggan (1976),
  Kinetics of Indomethicin absorption, elimination, and
    enterohepatic circulation in man.
  \emph{Journal of Pharmacokinetics and Biopharmaceutics}, \bold{4},
  255--280.

  Davidian, M. and Giltinan, D. M. (1995) \emph{Nonlinear Models for
    Repeated Measurement Data}, Chapman & Hall (section 5.2.4, p. 134)

  Pinheiro, J. C. and Bates, D. M. (2000) \emph{Mixed-effects Models in
    S and S-PLUS}, Springer.
}
\seealso{
  \code{\link{Indometh}} for models fitted to this dataset.
}
\keyword{datasets}
