/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import virtuoso.jena.driver.VirtGraph;

public class VirtPrefixMapping
extends PrefixMappingImpl {
    protected VirtGraph m_graph = null;

    public VirtPrefixMapping(VirtGraph virtGraph) {
        this.m_graph = virtGraph;
        Connection connection = this.m_graph.getConnection();
        String string = "DB.DBA.XML_SELECT_ALL_NS_DECLS (3)";
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                if (string3 == null || string3 == null) continue;
                super.setNsPrefix(string2, string3);
            }
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public PrefixMapping removeNsPrefix(String string) {
        Connection connection = this.m_graph.getConnection();
        String string2 = "DB.DBA.XML_REMOVE_NS_BY_PREFIX(?, 1)";
        super.removeNsPrefix(string);
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.execute();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
        return this;
    }

    public PrefixMapping setNsPrefix(String string, String string2) {
        super.setNsPrefix(string, string2);
        Connection connection = this.m_graph.getConnection();
        String string3 = "DB.DBA.XML_SET_NS_DECL(?, ?, 1)";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.execute();
        }
        catch (Exception exception) {
            throw new JenaException(exception.toString());
        }
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping prefixMapping) {
        return this.setNsPrefixes(prefixMapping.getNsPrefixMap());
    }

    public PrefixMapping setNsPrefixes(Map map) {
        this.checkUnlocked();
        for (Map.Entry entry : map.entrySet()) {
            this.setNsPrefix((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }
}

