MACRO(EXECUTE_PROGRAM)
  EXECUTE_PROCESS(COMMAND ${ARGV} RESULT_VARIABLE res)
  IF (res)
    MESSAGE(FATAL_ERROR "${ARGV} failed: " ${res})
  ENDIF()
ENDMACRO()
MACRO(EXECUTE_PROGRAM_EXPECT expect_res)
  EXECUTE_PROCESS(COMMAND ${ARGN} RESULT_VARIABLE res)
  IF (NOT res EQUAL ${expect_res})
    MESSAGE(FATAL_ERROR "${ARGN} failed: " ${res})
  ENDIF()
ENDMACRO()
MACRO(CBMCONVERT)
  EXECUTE_PROGRAM(${CBMCONVERT} ${ARGV})
ENDMACRO()

FILE(GLOB junk junk*.prg _.[p0-9][0-9][0-9] wyzxxxcz.[p0-9][0-9][0-9])
FILE(REMOVE f.c2n _.prg wyzxxxcz.prg ${junk} -P
  aaaaaaaa.prg aaaaaaaa.p00 zzzzzzzz.prg zzzzzzzz.p00
  00000000.prg 00000000.p00)
STRING(ASCII 3 3 4 24 4 t21)
STRING(ASCII 3 3 4 8 4 t5)
STRING(ASCII 119 65 47 31 217 218 219 255 120 120 120 99 218 99 193 255 f)
SET(s64 "                                                                ")
FILE(WRITE f.c2n "${t21}${f}${s64}${s64}${s64}${t5}${s64}${s64}${s64}")
EXECUTE_PROGRAM_EXPECT(2 ${CBMCONVERT} -I -c f.c2n f.c2n -P f.c2n)
FOREACH(i RANGE 1 10)
  CBMCONVERT(-Pc f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n)
ENDFOREACH()
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -Pc f.c2n)
FILE(GLOB junk _.[p0-9][0-9][0-9] wyzxxxcz.[p0-9][0-9][0-9])
FILE(REMOVE _.prg wyzxxxcz.prg ${junk})
FOREACH(i RANGE 1 100)
  CBMCONVERT(-Ic f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n)
ENDFOREACH()
CBMCONVERT(-Ic f.c2n)
EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -Ic f.c2n)
FILE(GLOB junk _.[p0-9][0-9][0-9] wyzxxxcz.[p0-9][0-9][0-9])
FILE(REMOVE f.c2n _.prg wyzxxxcz.prg ${junk})
STRING(ASCII 160 160 160 160 160 160 160 160 160 160 160 160 160 160 160 160 s)
FILE(WRITE f.c2n "${t21}${s}${s64}${s64}${s64}")
FILE(APPEND f.c2n "${t21}AAAAAAAAAAAAAAAA${s64}${s64}${s64}")
FILE(APPEND f.c2n "${t21}ZZZZZZZZZZZZZZZZ${s64}${s64}${s64}")
FILE(APPEND f.c2n "${t21}0000000000000000${s64}${s64}${s64}")
CBMCONVERT(-Ic f.c2n)
CBMCONVERT(-Pc f.c2n)
FILE(REMOVE _.prg _.p00
  aaaaaaaa.prg aaaaaaaa.p00 zzzzzzzz.prg zzzzzzzz.p00
  00000000.prg 00000000.p00)

FILE(WRITE f.c2n "${t21}JUNK            ${s64}${s64}${s64}")
FOREACH(i RANGE 1 10)
  CBMCONVERT(-c f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n)
ENDFOREACH()
IF (FALSE) # This is very slow
  FOREACH(i RANGE 11 1000)
    CBMCONVERT(-c f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n f.c2n)
  ENDFOREACH()
  CBMCONVERT(-c f.c2n)
  EXECUTE_PROGRAM_EXPECT(4 ${CBMCONVERT} -c f.c2n)
ENDIF()

FILE(GLOB junk junk~*.prg)
FILE(REMOVE f.c2n junk.prg ${junk})
