# Middleware (Проміжний шар)

У **FastAPI** можна додавати middleware (проміжний шар).

"Middleware" — це функція, яка працює з кожним **запитом** перед його обробкою будь-якою конкретною *операцією шляху* (*path operation*), а також з кожною **відповіддю** перед її поверненням.

* Middleware отримує кожен **запит**, що надходить до Вашого застосунку.
* Може виконати певні дії із цим **запитом** або запустити необхідний код.
* Далі передає **запит** для обробки основним застосунком (*операцією шляху*).
* Отримує **відповідь**, сформовану застосунком (*операцією шляху*).
* Може змінити цю **відповідь** або виконати додатковий код.
* Повертає **відповідь** клієнту.

/// note | Технічні деталі

Якщо у Вас є залежності з `yield`, код виходу виконається *після* middleware.

Якщо були заплановані фонові задачі (background tasks - розглянуто далі), вони виконаються *після* всіх middleware.

///

## Створення middleware

Щоб створити middleware, Ви використовуєте декоратор `@app.middleware("http")` на функції.

Функція middleware отримує:

* `Запит`.
* Функцію `call_next`, яка приймає `запит` як параметр.
    * Ця функція передає `запит` відповідній *операції шляху*.
    * Потім вона повертає `відповідь`, згенеровану цією *операцією шляху*.

* Ви можете ще змінити `відповідь` перед тим, як повернути її.


{* ../../docs_src/middleware/tutorial001.py hl[8:9,11,14] *}

/// tip | Порада

Не забувайте, що власні заголовки можна додавати, використовуючи <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers" class="external-link" target="_blank">префікс 'X-'</a>.

Але якщо у Вас є власні заголовки, які Ви хочете, щоб браузерний клієнт міг побачити, потрібно додати їх до Вашої конфігурації CORS (див. [CORS (Обмін ресурсами між різними джерелами)](cors.md){.internal-link target=_blank} за допомогою параметра `expose_headers`, описаного в <a href="https://www.starlette.io/middleware/#corsmiddleware" class="external-link" target="_blank">документації Starlette по CORS</a>.

///

/// note | Технічні деталі

Ви також можете використати `from starlette.requests import Request`.

**FastAPI** надає це для Вашої зручності як розробника. Але він походить безпосередньо зі Starlette.

///

### До і після `response`(`відповіді`)

Ви можете додати код, який буде виконуватися з `запитом` (`request`), до того, як його обробить будь-яка *операція шляху* (*path operation*).

Також Ви можете додати код, який буде виконуватися після того, як `відповідь` (`response`) буде згенеровано, перед тим як його повернути.

Наприклад, Ви можете додати власний заголовок `X-Process-Time`, який міститиме час у секундах, який витратився на обробку запиту та генерацію відповіді:

{* ../../docs_src/middleware/tutorial001.py hl[10,12:13] *}


/// tip | Підказка

Тут ми використовуємо <a href="https://docs.python.org/3/library/time.html#time.perf_counter" class="external-link" target="_blank">`time.perf_counter()`</a> замість `time.time()` оскільки він може бути більш точним для таких випадків. 🤓

///

## Інші middlewares

Ви можете пізніше прочитати більше про інші middlewares в [Advanced User Guide: Advanced Middleware](../advanced/middleware.md){.internal-link target=_blank}.

Ви дізнаєтесь, як обробляти <abbr title="Cross-Origin Resource Sharing">CORS</abbr> за допомогою middleware в наступному розділі.
