#!/bin/csh -f
#-----------------------------------------------------------------------------
# file:         hediff.csh
#
# description:
#       Shell script to compare two hdf output files, removing
#       differences caused by time/date stamps, host names
#       missing leading zeros, and other values that change 
#       over time
#
# usage:
#       hediff.csh sample_hefile_name.he5 hefile_name.he5...
#
# author:
#       Abe Taaheri
#
# history:
#       11-Jul-2014 AT  Initial version for hdfeos5
#
#
#   Inputs:
#     $1 = sample_hefile_name.he5
#     $2 = hefile_name.he5
#
#
  if ( ! -r $1 ) then
	echo "ERROR - unable to read input file $1"
	exit -1
  endif
#
  if ( ! -r $2 ) then
	echo "ERROR - unable to read input file $2"
	exit -1
  endif
#
#    set filen ="`basename $2 .he5`"
  set filen1 = "$1"
  set filen2 = "$2"
#
  set sample_temp = "/tmp/$$.sample"
  set out_temp    = "/tmp/$$.out"
  set sample_temp_orig = "/tmp/$$.sample_orig"
  set out_temp_orig    = "/tmp/$$.out_orig"
#
# dump he5 files onto ascii files
#
${HDFBIN}/h5dump $2 > &! ${sample_temp_orig}
${HDFBIN}/h5dump $1 > &! ${out_temp_orig}

     \rm -f $sample_temp $out_temp
     sed -e "/netcdf/d" \
			$sample_temp_orig > $sample_temp
     sed -e "/netcdf/d" \
                        $out_temp_orig > $out_temp


diff -bw $out_temp $sample_temp
\rm -f $sample_temp $out_temp
\rm -f $sample_temp_orig $out_temp_orig

echo " diff of $filen1 and $filen2 done"
