/* SPDX-FileCopyrightText: 2002-2005 - Paolo Maggi
 * SPDX-FileCopyrightText: 2014-2025 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <glib-object.h>
#include <gmodule.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_ENCODING (gtk_source_encoding_get_type ())

typedef struct _GtkSourceEncoding GtkSourceEncoding;

/**
 * GtkSourceEncodingDuplicates:
 * @GTK_SOURCE_ENCODING_DUPLICATES_KEEP_FIRST: Keep the first occurrence.
 * @GTK_SOURCE_ENCODING_DUPLICATES_KEEP_LAST: Keep the last occurrence.
 *
 * Specifies which #GtkSourceEncoding occurrence to keep when removing
 * duplicated encodings in a list with gtk_source_encoding_remove_duplicates().
 *
 * Since: 299.6
 */
typedef enum
{
	GTK_SOURCE_ENCODING_DUPLICATES_KEEP_FIRST,
	GTK_SOURCE_ENCODING_DUPLICATES_KEEP_LAST
} GtkSourceEncodingDuplicates;

G_MODULE_EXPORT
GType			gtk_source_encoding_get_type			(void) G_GNUC_CONST;

G_MODULE_EXPORT
GtkSourceEncoding *	gtk_source_encoding_new				(const gchar *charset);

G_MODULE_EXPORT
GtkSourceEncoding *	gtk_source_encoding_new_utf8			(void);

G_MODULE_EXPORT
GtkSourceEncoding *	gtk_source_encoding_new_from_locale		(void);

G_MODULE_EXPORT
GtkSourceEncoding *	gtk_source_encoding_copy			(const GtkSourceEncoding *enc);

G_MODULE_EXPORT
gpointer		gtk_source_encoding_copy_func			(gconstpointer src,
									 gpointer      data);

G_MODULE_EXPORT
void			gtk_source_encoding_free			(GtkSourceEncoding *enc);

G_MODULE_EXPORT
const gchar *		gtk_source_encoding_get_charset			(const GtkSourceEncoding *enc);

G_MODULE_EXPORT
gboolean		gtk_source_encoding_has_known_charset		(const GtkSourceEncoding *enc);

G_MODULE_EXPORT
const gchar *		gtk_source_encoding_get_name			(const GtkSourceEncoding *enc);

G_MODULE_EXPORT
gchar *			gtk_source_encoding_to_string			(const GtkSourceEncoding *enc);

G_MODULE_EXPORT
gboolean		gtk_source_encoding_is_utf8			(const GtkSourceEncoding *enc);

G_MODULE_EXPORT
gboolean		gtk_source_encoding_is_locale			(const GtkSourceEncoding *enc);

G_MODULE_EXPORT
gboolean		gtk_source_encoding_equals			(const GtkSourceEncoding *enc1,
									 const GtkSourceEncoding *enc2);

G_MODULE_EXPORT
gint			gtk_source_encoding_compare_func		(gconstpointer a,
									 gconstpointer b);

G_MODULE_EXPORT
GSList *		gtk_source_encoding_get_all			(void);

G_MODULE_EXPORT
GSList *		gtk_source_encoding_get_default_candidates	(void);

G_MODULE_EXPORT
GSList *		gtk_source_encoding_remove_duplicates		(GSList                      *list,
									 GtkSourceEncodingDuplicates  removal_type);

G_END_DECLS
