%define ver      2.2
%define rel      1

%global debug_package %{nil}

## Our optional build-time flags.  Since the configuration script
#  defaults to --enable-FEATURE we only set the --disable-FEATURE
#  versions here.  NOTE: We default to ENABLE
%{?_without_ldap: %define _without_ldap --disable-ldap}
%{?_without_ldap: %define _without_ldap --disable-ldap}
%{?_without_gdbm: %define _without_gdbm --disable-gdbm}
%{?_without_mysql: %define _without_mysql --disable-mysql}
%{?_without_pg: %define _without_pg --disable-pg}
%{?_without_pam: %define _without_pam --disable-pam}
%{?_without_ssl: %define _without_ssl --disable-ssl}
%{?_without_odbc: %define _without_odbc --disable-odbc}
%{?_without_bdb: %define _without_bdb --disable-bdb}
%{?_without_cdb: %define _without_cdb --disable-cdb}

Summary: Mail Retrieval Proxy
Name: perdition
Version: %ver
Release: %rel
License: GPL
Group: Applications/Internet
Source: http://horms.net/projects/perdition/download/%{ver}/perdition-%{ver}.tar.xz
BuildRoot: %{_tmppath}/perdition-%{PACKAGE_VERSION}-root
URL: http://horms.net/projects/perdition/
Provides: perdition-%{ver}-%{rel}
BuildRequires: gcc
BuildRequires: make
BuildRequires: libvanessa_logger0-devel >= 0.0.10
BuildRequires: libvanessa_adt1-devel >= 0.0.9
BuildRequires: libvanessa_socket2-devel >= 0.0.12
BuildRequires: zlib-devel
BuildRequires: pkgconfig
%{!?_without_gdbm:BuildRequires: gdbm-devel}
%{!?_without_mysql:BuildRequires: mysql-devel}
%{!?_without_pg:BuildRequires: postgresql-devel}
%{!?_without_pam:BuildRequires: pam-devel}
%{!?_without_ssl:BuildRequires: openssl-devel}
%{!?_without_odbc:BuildRequires: unixODBC-devel}

%if 0%{?centos_version} && 0%{?centos_version} < 600 || 0%{?rhel_version} && 0%{?rhel_version} < 600
BuildRequires: popt
%else
%if 0%{?mandriva_version}
BuildRequires: libpopt-devel
%else
BuildRequires: popt-devel
%endif
%endif

%if %{?_without_bdb:0}%{!?_without_bdb:1}
%if 0%{?centos_version} && 0%{?centos_version} < 700
BuildRequires: db-devel
%else
%if 0%{?rhel_version} && 0%{?rhel_version} < 700
BuildRequires: db-devel
%else
%if 0%{?suse_version}
BuildRequires: db-devel
%else
%if 0%{?mandriva_version}
BuildRequires: libdb4.6-devel
%else
%if 0%{?scientificlinux_version} == 600
BuildRequires: db4-devel
%else
BuildRequires: libdb-devel
%endif
%endif
%endif
%endif
%endif
%endif

%if %{?_without_ldap:0}%{!?_without_ldap:1}
%if 0%{?suse_version}
BuildRequires: openldap2-devel
%else
BuildRequires: openldap-devel
%endif
%endif

%if %{?_without_odbc:0}%{!?_without_odbc:1}
%if 0%{?suse_version} >= 1200 && 0%{?suse_version} <= 1320
BuildRequires: libtool-ltdl-devel
%endif
%endif

%if 0%{?suse_version}
PreReq: %insserv_prereq %fillup_prereq
%else
Requires(post):  chkconfig
Requires(preun): chkconfig
%if 0%{?mandriva_version}
%else
Requires(preun): initscripts
%endif
%endif

Requires: libvanessa_socket2 >= 0.0.12

%description
Perdition is a fully featured POP3 and IMAP4 proxy server. It is able to
handle both SSL and non-SSL connections and redirect users to a
real-server based on a database lookup. Perdition supports modular based
database access. ODBC, MySQL, PostgreSQL, GDBM, POSIX Regular Expression
and NIS modules ship with the distribution. The API for modules is open
allowing abitary modules to be written to allow access to any data store.

Perdition can be used to: Create large mail systems where a users mailbox
may be stored on one of several hosts.  Integrate different mail systems
together. Migrate between different email infastructure. And in firewall
applications.

Accepted build-time options (i.e. # rpmbuild --without XXX -ba perdition.spec) are:
  --without pam		Exclude PAM support
  --without ssl		Exclude SSL support
  --without cdb		Exclude CDB support
  --without mysql	Do not build libperditiondb_mysql0 package
  --without odbc	Do not build libperditiondb_odbc0 package
  --without pg		Do not build libperditiondb_pg0 package
  --without gdbm	Do not build libperditiondb_gdbm0 package
  --without bdb		Do not build libperditiondb_bdb0 package
  --without ldap	Do not build libperditiondb_ldap0 package

%package devel
Summary: Headers and static libraries for perditiondb library development
Group: Development/Libraries
Requires: perdition-%{ver}-%{rel}

%description devel
Perdition allows for arbitrary user database access through
shared libraries much in the manner of NSS in glibc. This package
provides headers and libraries that may be useful in the development
of perditiondb libraries.


%package -n libperditiondb_bdb0
Summary: Library to allow perdition to access Berkeley DB based pop maps
Group: Applications/Internet
License: GPL
Requires: perdition-%{ver}-%{rel}
Provides: perdition-bdb-%{ver}-%{rel}

%description -n libperditiondb_bdb0
Perdition allows for arbitrary user database access through shared
libraries much in the manner of NSS in glibc. This package allows a user
database to be sourced from a Berkeley DB.


%package -n libperditiondb_ldap0
Summary: Library to allow perdition to access LDAP based pop maps
Group: Applications/Internet
License: GPL
Requires: perdition-%{ver}-%{rel}
Provides: perdition-ldap-%{ver}-%{rel}

%description -n libperditiondb_ldap0
Perdition allows for arbitrary user database access through shared
libraries much in the manner of NSS in glibc. This package allows a user
database to be sourced from LDAP.


%package -n libperditiondb_mysql0
Summary: Library to allow perdition to access MySQL based pop maps
Group: Applications/Internet
License: GPL
Requires: perdition-%{ver}-%{rel}
Provides: perdition-mysql-%{ver}-%{rel}

%description -n libperditiondb_mysql0
Perdition allows for arbitrary user database access through shared
libraries much in the manner of NSS in glibc. This package allows a user
database stored in a MySQL database.


%package -n libperditiondb_postgresql0
Summary: Library to allow perdition to access PostgreSQL based pop maps
Group: Applications/Internet
License: GPL
Requires: perdition-%{ver}-%{rel}
Provides: perdition-postgresql-%{ver}-%{rel}

%description -n libperditiondb_postgresql0
Perdition allows for arbitrary user database access through shared
libraries much in the manner of NSS in glibc. This package allows a user
database stored in a PostgreSQL database.


%package -n libperditiondb_odbc0
Summary: Library to allow perdition to access pop maps via ODBC
Group: Applications/Internet
License: GPL
Requires: perdition-%{ver}-%{rel}
Provides: perdition-odbc-%{ver}-%{rel}

%description -n libperditiondb_odbc0
Perdition allows for arbitrary user database access through shared
libraries much in the manner of NSS in glibc. This package allows a user
access databases via ODBC.





%prep
%setup

%build

%configure \
  --with-ldap-schema-directory=no \
  --enable-shared \
  --disable-static \
  %{?_without_mysql} \
  %{?_without_odbc} \
  %{?_without_pg} \
  %{?_without_gdbm} \
  %{?_without_bdb} \
  %{?_without_cdb} \
  %{?_without_ldap}

make

%install
%if 0%{?suse_version}
	mkdir -p ${RPM_BUILD_ROOT}/etc/init.d
	mkdir -p ${RPM_BUILD_ROOT}/var/adm/fillup-templates
%else
	mkdir -p ${RPM_BUILD_ROOT}/etc/rc.d/init.d
	mkdir -p ${RPM_BUILD_ROOT}/etc/sysconfig
%endif

make DESTDIR=$RPM_BUILD_ROOT install-strip

%if 0%{?suse_version}
install -m755 \
  ${RPM_BUILD_DIR}/perdition-%{ver}/etc/rc.d/init.d/perdition.suse \
  ${RPM_BUILD_ROOT}/etc/init.d/perdition
install -m644 ${RPM_BUILD_DIR}/perdition-%{ver}/etc/sysconfig/perdition.suse \
  ${RPM_BUILD_ROOT}/var/adm/fillup-templates/sysconfig.perdition
%else
install -m755 \
  ${RPM_BUILD_DIR}/perdition-%{ver}/etc/rc.d/init.d/perdition.rh \
  ${RPM_BUILD_ROOT}/etc/rc.d/init.d/perdition
install -m644 ${RPM_BUILD_DIR}/perdition-%{ver}/etc/sysconfig/perdition \
  ${RPM_BUILD_ROOT}/etc/sysconfig/perdition
%endif

# Don't install .la and .so files
rm $RPM_BUILD_ROOT/%{_libdir}/*.{la,so}

%clean
rm -rf $RPM_BUILD_ROOT

%post
%if 0%{?suse_version}
	%{fillup_and_insserv -n perdition}
%else
%if 0%{?mandriva_version}
	%_post_service perdition
%else
        /sbin/chkconfig --add perdition
%endif
%endif
	make -C /etc/perdition/
ldconfig

%postun
ldconfig
%if 0%{?suse_version}
	%restart_on_update perdition
	%insserv_cleanup
%else
%if 0%{?mandriva_version}
%else
	if [ "$1" -ge "1" ] ; then
		/sbin/service perdition condrestart >/dev/null 2>&1 || :
	fi
%endif
%endif

%preun
%if 0%{?suse_version}
	%stop_on_removal perdition
%else
%if 0%{?mandriva_version}
	%_preun_service perdition
%else
	if [ $1 = 0 ]; then
		/sbin/service <script> stop >/dev/null 2>&1
		/sbin/chkconfig --del perdition
		make -C /etc/perdition/ clean
	fi
%endif
%endif

%files
%defattr(-,root,root)
%doc %attr(-, root, root) README
%doc %attr(-, root, root) ChangeLog TODO
%{_sbindir}/perdition
%{_sbindir}/perdition.*

# pam configuration
%if %{?_without_pam:0}%{!?_without_pam:1}
%config /etc/pam.d/perdition
%endif

%if 0%{?suse_version}
%config /etc/init.d/perdition
/var/adm/fillup-templates/sysconfig.perdition
%else
%config /etc/rc.d/init.d/perdition
%config /etc/sysconfig/perdition
%endif
%config /etc/perdition/perdition.conf
%{_mandir}/man8/perdition.*
%{_mandir}/man5/perditiondb.*

%config /etc/perdition/Makefile
%config /etc/perdition/Makefile.popmap
%config /etc/perdition/popmap

# nis map
%{_libdir}/libperditiondb_nis.so.0
%{_libdir}/libperditiondb_nis.so.0.0.0

# posix_regex map
%{_libdir}/libperditiondb_posix_regex.so.0
%{_libdir}/libperditiondb_posix_regex.so.0.0.0
%dir /etc/perdition
%config /etc/perdition/popmap.re

## gdbm map
%if %{?_without_gdbm:0}%{!?_without_gdbm:1}
%{_libdir}/libperditiondb_gdbm.so.0
%{_libdir}/libperditiondb_gdbm.so.0.0.0
%{_bindir}/makegdbm
%{_mandir}/man1/makegdbm.*
%endif

# daemon map
%{_libdir}/libperditiondb_daemon.so.0
%{_libdir}/libperditiondb_daemon.so.0.0.0
%{_libdir}/libperditiondb_daemon_base.so.0
%{_libdir}/libperditiondb_daemon_base.so.0.0.0

## bdb map
%if %{?_without_bdb:0}%{!?_without_bdb:1}
%files -n libperditiondb_bdb0
%defattr(-,root,root)
%{_libdir}/libperditiondb_bdb.so.0
%{_libdir}/libperditiondb_bdb.so.0.0.0
%{_bindir}/makebdb
%{_mandir}/man1/makebdb.*

%post -n libperditiondb_bdb0
ldconfig

%postun -n libperditiondb_bdb0
ldconfig
%endif

## ldap map
%if %{?_without_ldap:0}%{!?_without_ldap:1}
%files -n libperditiondb_ldap0
%defattr(-,root,root)
%doc %attr(-, root, root) perdition/db/ldap/perdition.schema
%{_libdir}/libperditiondb_ldap.so.0
%{_libdir}/libperditiondb_ldap.so.0.0.0
%{_sbindir}/perditiondb_ldap_makedb
%{_mandir}/man8/perditiondb_ldap_makedb.*

%post -n libperditiondb_ldap0
ldconfig

%postun -n libperditiondb_ldap0
ldconfig
%endif

## mysql map
%if %{?_without_mysql:0}%{!?_without_mysql:1}
%files -n libperditiondb_mysql0
%defattr(-,root,root)
%{_libdir}/libperditiondb_mysql.so.0
%{_libdir}/libperditiondb_mysql.so.0.0.0
%{_sbindir}/perditiondb_mysql_makedb
%{_mandir}/man8/perditiondb_mysql_makedb.*

%post -n libperditiondb_mysql0
ldconfig

%postun -n libperditiondb_mysql0
ldconfig
%endif

## postgresql map
%if %{?_without_pg:0}%{!?_without_pg:1}
%files -n libperditiondb_postgresql0
%defattr(-,root,root)
%{_libdir}/libperditiondb_postgresql.so.0
%{_libdir}/libperditiondb_postgresql.so.0.0.0
%{_sbindir}/perditiondb_postgresql_makedb
%{_mandir}/man8/perditiondb_postgresql_makedb.*

%post -n libperditiondb_postgresql0
ldconfig

%postun -n libperditiondb_postgresql0
ldconfig
%endif

## odbc map
%if %{?_without_odbc:0}%{!?_without_odbc:1}
%files -n libperditiondb_odbc0
%defattr(-,root,root)
%{_libdir}/libperditiondb_odbc.so.0
%{_libdir}/libperditiondb_odbc.so.0.0.0
%{_sbindir}/perditiondb_odbc_makedb
%{_mandir}/man8/perditiondb_odbc_makedb.*

%post -n libperditiondb_odbc0
ldconfig

%postun -n libperditiondb_odbc0
ldconfig
%endif

%changelog
* Tue Nov  1 2016 Simon Horman <horms@verge.net.au> (2.2)
  new release

* Sun Dec  1 2013 Simon Horman <horms@verge.net.au> (2.1)
  new release

* Fri Oct  4 2013 Simon Horman <horms@verge.net.au> (2.0)
  new release

* Tue Mar 20 2012 Simon Horman <horms@verge.net.au> (1.19rc5-1)
  new release

* Mon Sep 13 2010 Simon Horman <horms@verge.net.au> (1.19rc4-1)
  new release

* Thu Jul 29 2010 Simon Horman <horms@verge.net.au> (1.19rc3-1)
  new release

* Sat Jul 10 2010 Simon Horman <horms@verge.net.au> (1.19rc2-1)
  new release

* Tue Jul  6 2010 Simon Horman <horms@verge.net.au> (1.19rc1-1)
  new release

* Wed Jun 30 2010 Nic Bernstein <supprot@onlight.com> (1.18-2)
- Removed dependency on mysql, odbc and pam and added build-time config flags:
  --without pam       Exclude PAM support
  --without ssl       Exclude SSL support
  --without cdb       Exclude CDB support
  --without mysql     Do not build libperditiondb_mysql0 package
  --without odbc      Do not build libperditiondb_odbc0 package
  --without pg        Do not build libperditiondb_pg0 package
  --without gdbm      Do not build libperditiondb_gdbm0 package
  --without bdb       Do not build libperditiondb_bdb0 package
  --without ldap      Do not build libperditiondb_ldap0 package

* Fri Nov 27 2009 Simon Horman <horms@verge.net.au> (1.18-1)
  new release
