# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CreateManagementGroupDetails(Model):
    """The details of a management group used during creation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar version: The version number of the object.
    :vartype version: float
    :ivar updated_time: The date and time when this object was last updated.
    :vartype updated_time: datetime
    :ivar updated_by: The identity of the principal or process that updated
     the object.
    :vartype updated_by: str
    :param parent: Parent.
    :type parent: ~azure.mgmt.managementgroups.models.CreateParentGroupInfo
    """

    _validation = {
        'version': {'readonly': True},
        'updated_time': {'readonly': True},
        'updated_by': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'float'},
        'updated_time': {'key': 'updatedTime', 'type': 'iso-8601'},
        'updated_by': {'key': 'updatedBy', 'type': 'str'},
        'parent': {'key': 'parent', 'type': 'CreateParentGroupInfo'},
    }

    def __init__(self, **kwargs):
        super(CreateManagementGroupDetails, self).__init__(**kwargs)
        self.version = None
        self.updated_time = None
        self.updated_by = None
        self.parent = kwargs.get('parent', None)
