
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <XCAFView_Object.hxx>
#include <XCAFView_ProjectionType.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XCAFView_enums(py::module &main_module) {


py::module m = main_module.def_submodule("XCAFView", R"#()#");

// user-defined inclusion per module in the body

// enums
    py::enum_<XCAFView_ProjectionType>(m, "XCAFView_ProjectionType",R"#(Defines projection types of view)#")
        .value("XCAFView_ProjectionType_NoCamera",XCAFView_ProjectionType::XCAFView_ProjectionType_NoCamera)
        .value("XCAFView_ProjectionType_Parallel",XCAFView_ProjectionType::XCAFView_ProjectionType_Parallel)
        .value("XCAFView_ProjectionType_Central",XCAFView_ProjectionType::XCAFView_ProjectionType_Central).export_values();

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<XCAFView_Object ,opencascade::handle<XCAFView_Object>  , Standard_Transient >(m,"XCAFView_Object",R"#(Access object for saved viewAccess object for saved viewAccess object for saved view)#");

};

// user-defined post-inclusion per module

// user-defined post
