\name{attractorsToLaTeX}
\Rdversion{1.1}
\alias{attractorsToLaTeX}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Create LaTeX state table of attractors
}
\description{
Exports state tables of attractors (corresponding to the plot generated by \code{\link{plotAttractors}} with \code{mode="table"}) to a LaTeX document.
}
\usage{
attractorsToLaTeX(attractorInfo, 
                  subset, 
                  title = "", 
                  grouping = list(), 
                  plotFixed = TRUE,
                  onColor = "[gray]{0.9}",
                  offColor = "[gray]{0.6}",
                  reverse = FALSE, 
                  file = "attractors.tex")
}
\arguments{
  \item{attractorInfo}{
	An object of class \code{AttractorInfo}, as returned by \code{\link{getAttractors}}, or an object of class \code{SymbolicSimulation}, as returned by \code{\link{simulateSymbolicModel}}.
}

  \item{subset}{An subset of attractors to be exported. This is a vector of attractor indices in \code{attractorInfo}.}
  
  \item{grouping}{An optional structure to form groups of genes in the plot. This is a list with the following elements: 
 \describe{
  	\item{class}{A vector of names for the groups. These names will be printed in the region belonging to the group in the table.}
  	\item{index}{A list with the same length as \code{class}. Each element is a vector of gene indices belonging to the group.}}
}
 
  \item{title}{
	An optional title for the plot
}
  \item{plotFixed}{
	If this is true, genes with fixed values are included in the plot. Otherwise, these genes are not shown.
}
  \item{onColor}{
	An optional color value for the 1/ON values in the table. Defaults to dark grey.
}
  \item{offColor}{
	An optional color value for the 0/OFF values in the table. Defaults to light grey.	
}

  \item{reverse}{
Specifies the order of the genes in the plot. By default, the first gene is placed in the first row of the table. If \code{reverse=TRUE}, the first gene in the network is placed in the bottom row of the table. 
}

  \item{file}{
	The file to which the LaTeX document is written. Defaults to "attractors.tex".
}
}
\details{
This function creates LaTeX tables that visualize the states of synchronous attractors. Asynchronous attractors are ignored.
Attractors in \code{attractorInfo} are first grouped by length. Then, a LaTeX table environment is created for each attractor length (i.e. one plot with all attractors consisting of 1 state, one plot with all attractors consisting of 2 states, etc.).
The output file does not contain a document header and requires the inclusion of the packages \code{tabularx} and \code{colortbl}. The tables have the genes in the rows and the states of the attractors in the columns. If not specified otherwise, cells of the table are light grey for 0/OFF values and dark grey for 1/ON values. If \code{grouping} is set, the genes are rearranged according to the indices in the group, horizontal separation lines are plotted between the groups, and the group names are printed.
}
\value{
A list of matrices corresponding to the plots is returned. Each of these matrices has the genes in the rows and the states of the attractors in the columns.
}
\seealso{
\code{\link{getAttractors}}, \code{\link{plotAttractors}}, \code{\link{sequenceToLaTeX}}, \code{\link{plotSequence}}
}
\examples{
\dontrun{
# load example data
data(cellcycle)

# get attractors
attractors <- getAttractors(cellcycle)

# output LaTeX document
attractorsToLaTeX(attractors, file="attractors.tex")
}
}
