% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_sample_sizes.R
\name{relative_eff}
\alias{relative_eff}
\alias{relative_eff.default}
\alias{relative_eff.matrix}
\alias{relative_eff.array}
\alias{relative_eff.function}
\alias{relative_eff.importance_sampling}
\title{Convenience function for computing relative efficiencies}
\usage{
relative_eff(x, ...)

\method{relative_eff}{default}(x, chain_id, ...)

\method{relative_eff}{matrix}(x, chain_id, ..., cores = getOption("mc.cores", 1))

\method{relative_eff}{array}(x, ..., cores = getOption("mc.cores", 1))

\method{relative_eff}{`function`}(
  x,
  chain_id,
  ...,
  cores = getOption("mc.cores", 1),
  data = NULL,
  draws = NULL
)

\method{relative_eff}{importance_sampling}(x, ...)
}
\arguments{
\item{x}{A vector, matrix, 3-D array, or function. See the \strong{Methods (by
class)} section below for details on specifying \code{x}, but where
"log-likelihood" is mentioned replace it with one of the following
depending on the use case:
\itemize{
\item For use with the \code{\link[=loo]{loo()}} function, the values in \code{x} (or generated by
\code{x}, if a function) should be \strong{likelihood} values
(i.e., \code{exp(log_lik)}), not on the log scale.
\item For generic use with \code{\link[=psis]{psis()}}, the values in \code{x} should be the reciprocal
of the importance ratios (i.e., \code{exp(-log_ratios)}).
}}

\item{chain_id}{A vector of length \code{NROW(x)} containing MCMC chain
indexes for each each row of \code{x} (if a matrix) or each value in
\code{x} (if a vector). No \code{chain_id} is needed if \code{x} is a 3-D
array. If there are \code{C} chains then valid chain indexes are values
in \code{1:C}.}

\item{cores}{The number of cores to use for parallelization.}

\item{data, draws, ...}{Same as for the \code{\link[=loo]{loo()}} function method.}
}
\value{
A vector of relative effective sample sizes.
}
\description{
\code{relative_eff()} computes the the MCMC effective sample size divided by
the total sample size.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: A vector of length \eqn{S} (posterior sample size).

\item \code{matrix}: An \eqn{S} by \eqn{N} matrix, where \eqn{S} is the size
of the posterior sample (with all chains merged) and \eqn{N} is the number
of data points.

\item \code{array}: An \eqn{I} by \eqn{C} by \eqn{N} array, where \eqn{I}
is the number of MCMC iterations per chain, \eqn{C} is the number of
chains, and \eqn{N} is the number of data points.

\item \code{function}: A function \code{f()} that takes arguments \code{data_i} and \code{draws} and returns a
vector containing the log-likelihood for a single observation \code{i} evaluated
at each posterior draw. The function should be written such that, for each
observation \code{i} in \code{1:N}, evaluating\preformatted{f(data_i = data[i,, drop=FALSE], draws = draws)
}

results in a vector of length \code{S} (size of posterior sample). The
log-likelihood function can also have additional arguments but \code{data_i} and
\code{draws} are required.

If using the function method then the arguments \code{data} and \code{draws} must also
be specified in the call to \code{loo()}:
\itemize{
\item \code{data}: A data frame or matrix containing the data (e.g.
observed outcome and predictors) needed to compute the pointwise
log-likelihood. For each observation \code{i}, the \code{i}th row of
\code{data} will be passed to the \code{data_i} argument of the
log-likelihood function.
\item \code{draws}: An object containing the posterior draws for any
parameters needed to compute the pointwise log-likelihood. Unlike
\code{data}, which is indexed by observation, for each observation the
entire object \code{draws} will be passed to the \code{draws} argument of
the log-likelihood function.
\item The \code{...} can be used if your log-likelihood function takes additional
arguments. These arguments are used like the \code{draws} argument in that they
are recycled for each observation.
}

\item \code{importance_sampling}: If \code{x} is an object of class \code{"psis"}, \code{relative_eff()} simply returns
the \code{r_eff} attribute of \code{x}.
}}

\examples{
LLarr <- example_loglik_array()
LLmat <- example_loglik_matrix()
dim(LLarr)
dim(LLmat)

rel_n_eff_1 <- relative_eff(exp(LLarr))
rel_n_eff_2 <- relative_eff(exp(LLmat), chain_id = rep(1:2, each = 500))
all.equal(rel_n_eff_1, rel_n_eff_2)

}
