/*
 * secstr.c - hopefully secure wrappper for string-related functions
 * $Id: secstr.c 151 2004-06-05 15:15:18Z rdenisc $
 */

/***********************************************************************
 *  Copyright (C) 2002-2004 Remi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdarg.h>
#include <stdio.h>
#include <string.h>

#include "secstr.h"

/*
 * Secure wrapper for strncpy()
 */
char *secure_strncpy (char *dest, const char *src, size_t n)
{
	strncpy (dest, src, n);
	dest[n - 1] = 0;
	return dest;
}


/*
 * Secure wrapper for snprintf()
 */
int secure_snprintf (char *buf, size_t len, const char *fmt, ...)
{
	va_list ap;
	int res;

	va_start (ap, fmt);
	res = vsnprintf (buf, len, fmt, ap);
	va_end (ap);

	return res;
}
