/* xkeycaps, Copyright (c) 1991, 1992, 1993 Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the key surfaces of the German HP ITF
 * keyboards.  By Michael Piotrowski <mxp@linguistik.uni-erlangen.de>
 */

static struct key_strings hpitfde_caps [] = {

  /* Row 0 */

  {"Reset", "Break", 0},
  {"Stop", 0},
  {"F1", 0},
  {"F2", 0},
  {"F3", 0},
  {"F4", 0},
  {"Men\374", 0},
  {"Prog", "System", 0},
  {"F5", 0},
  {"F6", 0},
  {"F7", 0},
  {"F8", 0},
  {"L\366sche", "rightArrow", 0},
  {"L\366sche", "downArrow", 0},
  {"F9", 0},
  {"F10", 0},
  {"F11", 0},
  {"F12", 0},

  /* Row 2 */

  {"<", ">", 0},
  {"!", "1", 0},
  {"\"", "2", 0},
  {"\247", "3", 0},
  {"$", "4", 0},
  {"%", "5", 0},
  {"&", "6", 0},
  {"/", "7", 0},
  {"(", "8", 0},
  {")", "9", 0},
  {"=", "0", 0},
  {"?", "\337", 0},
  {"`", "'", 0},
  {"leftArrow", 0},
  {"Zeile +", 0},
  {"Zeile -", 0},
  {"*", 0},
  {"/", 0},
  {"+", 0},
  {"-", 0},

  /* Row 3 */

  {"Tab", 0},
  {"Q", 0},
  {"W", 0},
  {"E", 0},
  {"R", 0},
  {"T", 0},
  {"Z", 0},
  {"U", 0},
  {"I", 0},
  {"O", 0},
  {"P", 0},
  {"\334", 0, 0},
  {"*", "+", 0},
  {"^", "\243", 0},
  {"Zeich +", 0},
  {"Zeich -", 0},
  {"7", 0},
  {"8", 0},
  {"9", 0},
  {"Sende", 0},

  /* Row 4 */

  {"Gro\337/", "Klein", 0},
  {"KTRL", 0},
  {"A", 0},
  {"S", 0},
  {"D", 0},
  {"F", 0},
  {"G", 0},
  {"H", 0},
  {"J", 0},
  {"K", 0},
  {"L", 0},
  {"\326", 0},
  {"\304", 0},
  {"Eingabe", 0},
  {"Pos1", 0},
  {"Seite", "upArrow", 0},
  {"4", 0},
  {"5", 0},
  {"6", 0},
  {",", 0},

  /* Row 5 */

  {"DEL", "ESC", 0},
  {"Umschalt", 0},
  {"Y", 0},
  {"X", 0},
  {"C", 0},
  {"V", 0},
  {"B", 0},
  {"N", 0},
  {"M", 0},
  {";", ",", 0},
  {":", ".", 0},
  {"_", "-", 0},
  {"Umschalt", 0},
  {"Auswahl", 0},
  {"UpArrow",0},
  {"Seite", "downArrow", 0},
  {"1", 0},
  {"2", 0},
  {"3", 0},
  {"Tab", 0},

  /* Row 6 */

  {"Drucke", "Sende", 0},
  {"Sonder-", "zeichen", 0},
  {" ", 0},
  {"Sonder-", "zeichen", 0},
  {"LeftArrow", 0},
  {"DownArrow", 0},
  {"RightArrow", 0},
  {"0", 0},
  {".", 0}
};
