/*
 * (llc_if.c) - Defines interface to LLC Layer Management Entity
 *
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 

#define LLC_LM_C

#include <linux/kernel.h>
#include <linux/malloc.h>
#include <net/cm_types.h>

#include <net/stk_rsrc.h>
#include <net/llc_dbg.h>


#ifdef LLC_LM_DBG
  #define  DBG_MSG(body) { printk body; }
#else
  #define  DBG_MSG(body)  ;
#endif

/* defined constants */

/* data structures */

typedef struct
{
	us8	in_use;
	us32	type;
	us32	handle;
	us16	status;
} lm_status;


static int	Module_init = NO;


/* use an array for now */
static lm_status       Lm_db [LLC_LM_COMPONENT_DB_SIZE];


/* global static functions */

static us16	db_entry_get (lm_status ** db_entry);
//static us16	db_entry_rtn (lm_status * db_entry);
static us16	db_entry_find (us32 component_handle, lm_status ** entry);



us16
llc_lm_init (void)
{
	if (Module_init == YES) {
		return (0);
	}
	memset (Lm_db, 0, sizeof (Lm_db));
	Module_init = YES;
	return (0);
}


us16
llc_lm_exit (void)
{
	if (Module_init == NO) {
		return (0);
	}
	Module_init = NO;
	return (0);
}


us16
lm_report_status (us8 component_type, us32 component_handle, us16 status_value)
{
	us16		rc;
	lm_status *	component;
   
	return (0);
	if (Module_init == NO) {
		return (1);
	}
	rc = db_entry_find (component_handle, &component);
	if (!rc) {
		component->status = status_value;
	} else {
		rc = db_entry_get (&component);
		if (!rc) {
			component->type = component_type;
			component->handle = component_handle;
			component->status = status_value;
		}
	}
	return (rc);
}



static us16
db_entry_get (lm_status ** db_entry)
{
	int	i;
	us16	rc = 1;

	for (i = 0; (i < LLC_LM_COMPONENT_DB_SIZE) && rc; i++) {
		if (Lm_db [i].in_use == NO) {
			Lm_db [i].in_use = YES;
			*db_entry = &Lm_db [i];
			rc = 0;
		}
	}
	return (rc);
}


static us16
db_entry_find (us32 component_handle, lm_status ** db_entry)
{
	int	i;
	us16	rc = 1;

	for (i = 0; (i < LLC_LM_COMPONENT_DB_SIZE) && rc; i++) {
		if ((Lm_db [i].in_use == YES) &&
				(Lm_db [i].handle == component_handle)) {
			*db_entry = &Lm_db [i];
			rc = 0;
		}
	}
	return (rc);
}
