/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Station component state table 
 */


#ifndef LLC_STAT_H
#define LLC_STAT_H


/* Station component states */
#define STATION_STATE_DOWN             1           /* initial state */
#define STATION_STATE_DUP_ADDR_CHK     2
#define STATION_STATE_UP               3

#define NBR_STATION_STATES             3           /* size of state table */


/* Station component state table structure */
typedef struct
{
#if 0
   us8                    event;
#else
   station_event_t        event;
#endif
   us8                    next_state;
   station_action_t *     event_actions;
} station_state_transition_t;


typedef struct
{
   us8                               current_state;
   station_state_transition_t **     transitions;
                           
} station_state_t;


#ifdef LLC_STAT_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_STAT_C */

EXTRN station_state_t     Station_state_table [NBR_STATION_STATES];

#endif /* LLC_STAT_H */

