struct syscall_info {
  int num_params;
  const char *name;
};

struct syscall_info syscall_info_table[]={
	{ 0,		"setup"		}, /* 0 */
	{ 1,		"_exit"		}, /* 1 */
	{ 0,		"fork"		}, /* 2 */
	{ 3,		"read"		}, /* 3 */
	{ 3,		"write"		}, /* 4 */
	{ 3,		"open"		}, /* 5 */
	{ 1,		"close"		}, /* 6 */
	{ 3,		"waitpid"	}, /* 7 */
	{ 2,		"creat"		}, /* 8 */
	{ 2,		"link"		}, /* 9 */
	{ 1,		"unlink"	}, /* 10 */
	{ 3,		"execve"	}, /* 11 */
	{ 1,		"chdir"		}, /* 12 */
	{ 1,		"time"		}, /* 13 */
	{ 3,		"mknod"		}, /* 14 */
	{ 2,		"chmod"		}, /* 15 */
	{ 3,		"lchown"	}, /* 16 */
	{ 0,		"break"		}, /* 17 */
	{ 2,		"oldstat"	}, /* 18 */
	{ 3,		"lseek"		}, /* 19 */
	{ 0,		"getpid"	}, /* 20 */
	{ 5,		"mount"		}, /* 21 */
	{ 1,		"oldumount"	}, /* 22 */
	{ 1,		"setuid"	}, /* 23 */
	{ 0,		"getuid"	}, /* 24 */
	{ 1,		"stime"		}, /* 25 */
	{ 4,		"ptrace"	}, /* 26 */
	{ 1,		"alarm"		}, /* 27 */
	{ 2,		"oldfstat"	}, /* 28 */
	{ 0,		"pause"		}, /* 29 */
	{ 2,		"utime"		}, /* 30 */
	{ 2,		"stty"		}, /* 31 */
	{ 2,		"gtty"		}, /* 32 */
	{ 2,		"access"	}, /* 33 */
	{ 1,		"nice"		}, /* 34 */
	{ 0,		"ftime"		}, /* 35 */
	{ 0,		"sync"		}, /* 36 */
	{ 2,		"kill"		}, /* 37 */
	{ 2,		"rename"	}, /* 38 */
	{ 2,		"mkdir"		}, /* 39 */
	{ 1,		"rmdir"		}, /* 40 */
	{ 1,		"dup"		}, /* 41 */
	{ 1,		"pipe"		}, /* 42 */
	{ 1,		"times"		}, /* 43 */
	{ 0,		"prof"		}, /* 44 */
	{ 1,		"brk"		}, /* 45 */
	{ 1,		"setgid"	}, /* 46 */
	{ 0,		"getgid"	}, /* 47 */
	{ 3,		"signal"	}, /* 48 */
	{ 0,		"geteuid"	}, /* 49 */
	{ 0,		"getegid"	}, /* 50 */
	{ 1,		"acct"		}, /* 51 */
	{ 2,		"umount"	}, /* 52 */
	{ 0,		"lock"		}, /* 53 */
	{ 3,		"ioctl"		}, /* 54 */
	{ 3,		"fcntl"		}, /* 55 */
	{ 0,		"mpx"		}, /* 56 */
	{ 2,		"setpgid"	}, /* 57 */
	{ 2,		"ulimit"	}, /* 58 */
        { 1,	        "oldolduname"	}, /* 59 */
	{ 1,		"umask"		}, /* 60 */
	{ 1,		"chroot"	}, /* 61 */
	{ 2,		"ustat"		}, /* 62 */
	{ 2,		"dup2"		}, /* 63 */
	{ 0,		"getppid"	}, /* 64 */
	{ 0,		"getpgrp"	}, /* 65 */
	{ 0,		"setsid"	}, /* 66 */
	{ 3,		"sigaction"	}, /* 67 */
	{ 0,		"siggetmask"	}, /* 68 */
	{ 1,		"sigsetmask"	}, /* 69 */
	{ 2,		"setreuid"	}, /* 70 */
	{ 2,		"setregid"	}, /* 71 */
	{ 3,		"sigsuspend"	}, /* 72 */
	{ 1,		"sigpending"	}, /* 73 */
	{ 2,	        "sethostname"	}, /* 74 */
	{ 2,		"setrlimit"	}, /* 75 */
	{ 2,		"getrlimit"	}, /* 76 */
	{ 2,		"getrusage"	}, /* 77 */
	{ 2,	        "gettimeofday"	}, /* 78 */
	{ 2,	        "settimeofday"	}, /* 79 */
	{ 2,		"getgroups"	}, /* 80 */
	{ 2,		"setgroups"	}, /* 81 */
	{ 1,		"oldselect"	}, /* 82 */
	{ 2,		"symlink"	}, /* 83 */
	{ 2,		"oldlstat"	}, /* 84 */
	{ 3,		"readlink"	}, /* 85 */
	{ 1,		"uselib"	}, /* 86 */
	{ 1,		"swapon"	}, /* 87 */
	{ 3,		"reboot"	}, /* 88 */
	{ 3,		"readdir"	}, /* 89 */
	{ 6,		"old_mmap"   	}, /* 90 */
	{ 2,		"munmap"	}, /* 91 */
	{ 2,		"truncate"	}, /* 92 */
	{ 2,		"ftruncate"	}, /* 93 */
	{ 2,		"fchmod"	}, /* 94 */
	{ 3,		"fchown"	}, /* 95 */
	{ 2,	        "getpriority"	}, /* 96 */
	{ 3,	        "setpriority"	}, /* 97 */
	{ 4,		"profil"	}, /* 98 */
	{ 2,		"statfs"	}, /* 99 */
	{ 2,		"fstatfs"	}, /* 100 */
	{ 3,		"ioperm"	}, /* 101 */
	{ 2,		"socketcall"	}, /* 102 */
	{ 3,		"syslog"	}, /* 103 */
	{ 3,		"setitimer"	}, /* 104 */
	{ 2,		"getitimer"	}, /* 105 */
	{ 2,		"stat"		}, /* 106 */
	{ 2,		"lstat"		}, /* 107 */
	{ 2,		"fstat"		}, /* 108 */
	{ 1,		"olduname"	}, /* 109 */
	{ 1,		"iopl"		}, /* 110 */
	{ 0,		"vhangup"	}, /* 111 */
	{ 0,		"idle"		}, /* 112 */
	{ 1,		"vm86old"	}, /* 113 */
	{ 4,		"wait4"		}, /* 114 */
	{ 1,		"swapoff"	}, /* 115 */
	{ 1,		"sysinfo"	}, /* 116 */
	{ 5,		"ipc"		}, /* 117 */
	{ 1,		"fsync"		}, /* 118 */
	{ 1,		"sigreturn"	}, /* 119 */
	{ 2,		"clone"		}, /* 120 */
	{ 2,	        "setdomainname"	}, /* 121 */
	{ 1,		"uname"		}, /* 122 */
	{ 3,		"modify_ldt"	}, /* 123 */
	{ 1,		"adjtimex"	}, /* 124 */
	{ 3,		"mprotect"	}, /* 125 */
	{ 3,	        "sigprocmask"	}, /* 126 */
	{ 2,	        "create_module"	}, /* 127 */
	{ 2,	        "init_module"	}, /* 128 */
	{ 1,	        "delete_module"	}, /* 129 */
	{ 1,	        "get_kernel_syms"}, /* 130 */
	{ 4,		"quotactl"	}, /* 131 */
	{ 1,		"getpgid"	}, /* 132 */
	{ 1,		"fchdir"	}, /* 133 */
	{ 0,		"bdflush"	}, /* 134 */
	{ 3,		"sysfs"		}, /* 135 */
	{ 1,	        "personality"	}, /* 136 */
	{ 5,	        "afs_syscall"	}, /* 137 */
	{ 1,		"setfsuid"	}, /* 138 */
	{ 1,		"setfsgid"	}, /* 139 */
	{ 5,		"_llseek"	}, /* 140 */
	{ 3,		"getdents"	}, /* 141 */
	{ 5,		"select"	}, /* 142 */
	{ 2,		"flock"		}, /* 143 */
	{ 3,		"msync"		}, /* 144 */
	{ 3,		"readv"		}, /* 145 */
	{ 3,		"writev"	}, /* 146 */
	{ 1,		"getsid"	}, /* 147 */
	{ 1,		"fdatasync"	}, /* 148 */
	{ 1,		"_sysctl"	}, /* 149 */
	{ 1,		"mlock"		}, /* 150 */
	{ 2,		"munlock"	}, /* 151 */
	{ 2,		"mlockall"	}, /* 152 */
	{ 1,		"munlockall"	}, /* 153 */
	{ 0,	        "sched_setparam"}, /* 154 */
	{ 2,	        "sched_getparam"}, /* 155 */
	{ 3,	        "sched_setscheduler"}, /* 156 */
	{ 1,	        "sched_getscheduler"}, /* 157 */
	{ 0,	        "sched_yield"}, /* 158 */
	{ 1,            "sched_get_priority_max"}, /* 159 */
	{ 1,            "sched_get_priority_min"}, /* 160 */
	{ 2,            "sched_rr_get_interval"}, /* 161 */
	{ 2,		"nanosleep"	}, /* 162 */
	{ 4,		"mremap"	}, /* 163 */
	{ 3,		"setresuid"	}, /* 164 */
	{ 3,		"getresuid"	}, /* 165 */
	{ 5,		"vm86"		}, /* 166 */
	{ 5,	        "query_module"	}, /* 167 */
	{ 3,		"poll"		}, /* 168 */
	{ 3,		"nfsservctl"	}, /* 169 */
	{ 3,		"setresgid"	}, /* 170 */
	{ 3,		"getresgid"	}, /* 171 */
	{ 5,		"prctl"		}, /* 172 */
	{ 1,		"rt_sigreturn"	}, /* 173 */
	{ 4,	        "rt_sigaction"  }, /* 174 */
	{ 4,	        "rt_sigprocmask"}, /* 175 */
	{ 2,	        "rt_sigpending"	}, /* 176 */
	{ 4,	        "rt_sigtimedwait"}, /* 177 */
	{ 3,            "rt_sigqueueinfo"}, /* 178 */
	{ 2,	        "rt_sigsuspend"	}, /* 179 */

	{ 5,		"pread"		}, /* 180 */
	{ 5,		"pwrite"	}, /* 181 */
	{ 3,		"chown"		}, /* 182 */
	{ 2,		"getcwd"	}, /* 183 */
	{ 2,		"capget"	}, /* 184 */
	{ 2,		"capset"	}, /* 185 */
	{ 2,	        "sigaltstack"	}, /* 186 */
	{ 4,		"sendfile"	}, /* 187 */
	{ 5,		"SYS_188"	}, /* 188 */
	{ 5,		"SYS_189"	}, /* 189 */
	{ 0,		"vfork"		}, /* 190 */
	{ 5,		"getrlimit"	}, /* 191 */
	{ 6,		"mmap2"		}, /* 192 */
	{ 5,		"truncate64"	}, /* 193 */
	{ 5,		"ftruncate64"	}, /* 194 */
	{ 2,		"stat64"	}, /* 195 */
	{ 2,		"lstat64"	}, /* 196 */
	{ 2,		"fstat64"	}, /* 197 */
        { 3,		"lchown32"	}, /* 198 */
        { 0,		"getuid32"	}, /* 199 */

	{ 0,		"getgid32"	}, /* 200 */
	{ 0,		"geteuid32"	}, /* 201 */
	{ 0,		"getegid32"	}, /* 202 */
	{ 2,		"setreuid32"	}, /* 203 */
	{ 2,		"setregid32"	}, /* 204 */
	{ 2,		"getgroups32"	}, /* 205 */
	{ 2,		"setgroups32"	}, /* 206 */
	{ 3,		"fchown32"	}, /* 207 */
	{ 3,		"setresuid32"	}, /* 208 */
	{ 3,		"getresuid32"	}, /* 209 */
	{ 3,		"setresgid32"	}, /* 210 */
	{ 3,		"getsetgid32"	}, /* 211 */
	{ 3,		"chown32"	}, /* 212 */
	{ 1,		"setuid32"	}, /* 213 */
	{ 1,		"setgid32"	}, /* 214 */
	{ 1,		"setfsuid32"	}, /* 215 */
	{ 1,		"setfsgid32"	}, /* 216 */
	{ 2,		"pivot_root"	}, /* 217 */
	{ 3,		"mincore"	}, /* 218 */
	{ 3,		"madvise"	}, /* 219 */
	{ 4,		"getdents64"	}, /* 220 */
	{ 3,		"fcntl64"	}, /* 221 */
	{ 4,		"SYS_222"	}, /* 222 */
	{ 4,		"SYS_223"	}, /* 223 */
	{ 4,		"SYS_224"	}, /* 224 */
	{ 5,		"SYS_225"	}, /* 225 */
	{ 5,		"SYS_226"	}, /* 226 */
	{ 5,		"SYS_227"	}, /* 227 */
	{ 5,		"SYS_228"	}, /* 228 */
	{ 5,		"SYS_229"	}, /* 229 */
	{ 8,		"socket_subcall"}, /* 230 */
	{ 3,		"socket"	}, /* 231 */
	{ 3,		"bind"		}, /* 232 */
	{ 3,		"connect"	}, /* 233 */
	{ 2,		"listen"	}, /* 234 */
	{ 3,		"accept"	}, /* 235 */
	{ 3,	        "getsockname"	}, /* 236 */
	{ 3,	        "getpeername"	}, /* 237 */
	{ 4,		"socketpair"	}, /* 238 */
	{ 4,		"send"		}, /* 239 */
	{ 4,		"recv"		}, /* 240 */
	{ 6,		"sendto"	}, /* 241 */
	{ 6,		"recvfrom"	}, /* 242 */
	{ 2,		"shutdown"	}, /* 243 */
	{ 5,		"setsockopt"	}, /* 244 */
	{ 5,		"getsockopt"	}, /* 245 */
	{ 5,		"sendmsg"	}, /* 246 */
	{ 5,		"recvmsg"	}, /* 247 */
	{ 5,		"SYS_248"	}, /* 248 */
	{ 5,		"SYS_249"	}, /* 249 */
	{ 4,		"ipc_subcall"	}, /* 250 */
	{ 4,		"semop"		}, /* 251 */
	{ 4,		"semget"	}, /* 252 */
	{ 4,		"semctl"	}, /* 253 */
	{ 4,		"ipc_subcall"	}, /* 254 */
	{ 4,		"ipc_subcall"	}, /* 255 */
	{ 4,		"ipc_subcall"	}, /* 256 */
	{ 4,		"ipc_subcall"	}, /* 257 */
	{ 4,		"ipc_subcall"	}, /* 258 */
	{ 4,		"ipc_subcall"	}, /* 259 */
	{ 4,		"ipc_subcall"	}, /* 260 */
	{ 4,		"msgsnd"	}, /* 261 */
	{ 4,		"msgrcv"	}, /* 262 */
	{ 4,		"msgget"	}, /* 263 */
	{ 4,		"msgctl"	}, /* 264 */
	{ 4,		"ipc_subcall"	}, /* 265 */
	{ 4,		"ipc_subcall"	}, /* 266 */
	{ 4,		"ipc_subcall"	}, /* 267 */
	{ 4,		"ipc_subcall"	}, /* 268 */
	{ 4,		"ipc_subcall"	}, /* 269 */
	{ 4,		"ipc_subcall"	}, /* 270 */
	{ 4,		"shmat"		}, /* 271 */
	{ 4,		"shmdt"		}, /* 272 */
	{ 4,		"shmget"	}, /* 273 */
	{ 4,		"shmctl"	}, /* 274 */
	{ 5,		"SYS_275"	}, /* 275 */
	{ 5,		"SYS_276"	}, /* 276 */
	{ 5,		"SYS_277"	}, /* 277 */
	{ 5,		"SYS_278"	}, /* 278 */
	{ 5,		"SYS_279"	}, /* 279 */
	{ 8,		"socket_subcall"}, /* 280 */
	{ 3,		"socket"	}, /* 281 */
	{ 3,		"bind"		}, /* 282 */
	{ 3,		"connect"	}, /* 283 */
	{ 2,		"listen"	}, /* 284 */
	{ 3,		"accept"	}, /* 285 */
	{ 3,	        "getsockname"	}, /* 286 */
	{ 3,	        "getpeername"	}, /* 287 */
	{ 4,		"socketpair"	}, /* 288 */
	{ 4,		"send"		}, /* 289 */
	{ 4,		"recv"		}, /* 290 */
	{ 6,		"sendto"	}, /* 291 */
	{ 6,		"recvfrom"	}, /* 292 */
	{ 2,		"shutdown"	}, /* 293 */
	{ 5,		"setsockopt"	}, /* 294 */
	{ 5,		"getsockopt"	}, /* 295 */
	{ 5,		"sendmsg"	}, /* 296 */
	{ 5,		"recvmsg"	}, /* 297 */
	{ 5,		"SYS_298"	}, /* 298 */
	{ 5,		"SYS_299"	}, /* 299 */
};

#define NUM_SYSCALL_INFO_ENTRIES (sizeof(syscall_info_table)/sizeof(struct syscall_info))
