# hinoko-sys crate

Rust FFI bindings and wrappers for
[hinoko library](https://git.kernel.org/pub/scm/libs/ieee1394/libhinoko.git/) to operate OHCI 1394
hardware via Linux FireWire character device for isochronous communication in IEEE 1394 bus.

The hinoko library version 0.8.0 is the minimum supported version for underlying library.

The hinoko-sys crate is automatically generated by [gir tool](https://gtk-rs.org/gir/book/) provided
by [gtk-rs project](https://gtk-rs.org/). Hinoko-0.0 file from hinoko library is used for the
generation.

## License

The hinoko-sys crate is released under [MIT license](https://spdx.org/licenses/MIT.html).

## Dependency

The hinoko-sys crate depends on FFI crates provided by [gtk-rs project](https://gtk-rs.org/) for
type/object system, event loop, and dispacher.

## Features

* dox

   * Suppress detection of installed hinoko library. It's automatically enabled when generating
     documentation in docs.rs.

## Repository

The hinoko-sys crate is maintained by Takashi Sakamoto for upstream of Linux FireWire subsystem.
The remote repository locates in <https://git.kernel.org/pub/scm/libs/ieee1394/hinoko-rs.git/>.

## Support

If finding issue, please file it in <https://github.com/takaswie/hinoko-rs/> which is the mirror of
upstream for user support and continuous integration.
