// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#![cfg(unix)]

use hinoko_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::{Command, Stdio};
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["hinoko"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!("Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",);
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut cmd = Command::new(exe);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }

    Ok(String::from_utf8(out.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "HinokoFwIsoCtxError",
        Layout {
            size: size_of::<HinokoFwIsoCtxError>(),
            alignment: align_of::<HinokoFwIsoCtxError>(),
        },
    ),
    (
        "HinokoFwIsoCtxInterface",
        Layout {
            size: size_of::<HinokoFwIsoCtxInterface>(),
            alignment: align_of::<HinokoFwIsoCtxInterface>(),
        },
    ),
    (
        "HinokoFwIsoCtxMatchFlag",
        Layout {
            size: size_of::<HinokoFwIsoCtxMatchFlag>(),
            alignment: align_of::<HinokoFwIsoCtxMatchFlag>(),
        },
    ),
    (
        "HinokoFwIsoCtxMode",
        Layout {
            size: size_of::<HinokoFwIsoCtxMode>(),
            alignment: align_of::<HinokoFwIsoCtxMode>(),
        },
    ),
    (
        "HinokoFwIsoIrMultiple",
        Layout {
            size: size_of::<HinokoFwIsoIrMultiple>(),
            alignment: align_of::<HinokoFwIsoIrMultiple>(),
        },
    ),
    (
        "HinokoFwIsoIrMultipleClass",
        Layout {
            size: size_of::<HinokoFwIsoIrMultipleClass>(),
            alignment: align_of::<HinokoFwIsoIrMultipleClass>(),
        },
    ),
    (
        "HinokoFwIsoIrSingle",
        Layout {
            size: size_of::<HinokoFwIsoIrSingle>(),
            alignment: align_of::<HinokoFwIsoIrSingle>(),
        },
    ),
    (
        "HinokoFwIsoIrSingleClass",
        Layout {
            size: size_of::<HinokoFwIsoIrSingleClass>(),
            alignment: align_of::<HinokoFwIsoIrSingleClass>(),
        },
    ),
    (
        "HinokoFwIsoIt",
        Layout {
            size: size_of::<HinokoFwIsoIt>(),
            alignment: align_of::<HinokoFwIsoIt>(),
        },
    ),
    (
        "HinokoFwIsoItClass",
        Layout {
            size: size_of::<HinokoFwIsoItClass>(),
            alignment: align_of::<HinokoFwIsoItClass>(),
        },
    ),
    (
        "HinokoFwIsoResourceAuto",
        Layout {
            size: size_of::<HinokoFwIsoResourceAuto>(),
            alignment: align_of::<HinokoFwIsoResourceAuto>(),
        },
    ),
    (
        "HinokoFwIsoResourceAutoClass",
        Layout {
            size: size_of::<HinokoFwIsoResourceAutoClass>(),
            alignment: align_of::<HinokoFwIsoResourceAutoClass>(),
        },
    ),
    (
        "HinokoFwIsoResourceAutoError",
        Layout {
            size: size_of::<HinokoFwIsoResourceAutoError>(),
            alignment: align_of::<HinokoFwIsoResourceAutoError>(),
        },
    ),
    (
        "HinokoFwIsoResourceError",
        Layout {
            size: size_of::<HinokoFwIsoResourceError>(),
            alignment: align_of::<HinokoFwIsoResourceError>(),
        },
    ),
    (
        "HinokoFwIsoResourceInterface",
        Layout {
            size: size_of::<HinokoFwIsoResourceInterface>(),
            alignment: align_of::<HinokoFwIsoResourceInterface>(),
        },
    ),
    (
        "HinokoFwIsoResourceOnce",
        Layout {
            size: size_of::<HinokoFwIsoResourceOnce>(),
            alignment: align_of::<HinokoFwIsoResourceOnce>(),
        },
    ),
    (
        "HinokoFwIsoResourceOnceClass",
        Layout {
            size: size_of::<HinokoFwIsoResourceOnceClass>(),
            alignment: align_of::<HinokoFwIsoResourceOnceClass>(),
        },
    ),
    (
        "HinokoFwScode",
        Layout {
            size: size_of::<HinokoFwScode>(),
            alignment: align_of::<HinokoFwScode>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) HINOKO_FW_ISO_CTX_ERROR_ALLOCATED", "1"),
    ("(gint) HINOKO_FW_ISO_CTX_ERROR_CHUNK_UNREGISTERED", "5"),
    ("(gint) HINOKO_FW_ISO_CTX_ERROR_FAILED", "0"),
    ("(gint) HINOKO_FW_ISO_CTX_ERROR_MAPPED", "3"),
    ("(gint) HINOKO_FW_ISO_CTX_ERROR_NOT_ALLOCATED", "2"),
    ("(gint) HINOKO_FW_ISO_CTX_ERROR_NOT_MAPPED", "4"),
    ("(gint) HINOKO_FW_ISO_CTX_ERROR_NO_ISOC_CHANNEL", "6"),
    ("(guint) HINOKO_FW_ISO_CTX_MATCH_FLAG_TAG0", "1"),
    ("(guint) HINOKO_FW_ISO_CTX_MATCH_FLAG_TAG1", "2"),
    ("(guint) HINOKO_FW_ISO_CTX_MATCH_FLAG_TAG2", "4"),
    ("(guint) HINOKO_FW_ISO_CTX_MATCH_FLAG_TAG3", "8"),
    ("(gint) HINOKO_FW_ISO_CTX_MODE_IR_MULTIPLE", "2"),
    ("(gint) HINOKO_FW_ISO_CTX_MODE_IR_SINGLE", "1"),
    ("(gint) HINOKO_FW_ISO_CTX_MODE_IT", "0"),
    ("(gint) HINOKO_FW_ISO_RESOURCE_AUTO_ERROR_ALLOCATED", "1"),
    ("(gint) HINOKO_FW_ISO_RESOURCE_AUTO_ERROR_FAILED", "0"),
    (
        "(gint) HINOKO_FW_ISO_RESOURCE_AUTO_ERROR_NOT_ALLOCATED",
        "2",
    ),
    ("(gint) HINOKO_FW_ISO_RESOURCE_ERROR_EVENT", "4"),
    ("(gint) HINOKO_FW_ISO_RESOURCE_ERROR_FAILED", "0"),
    ("(gint) HINOKO_FW_ISO_RESOURCE_ERROR_NOT_OPENED", "2"),
    ("(gint) HINOKO_FW_ISO_RESOURCE_ERROR_OPENED", "1"),
    ("(gint) HINOKO_FW_ISO_RESOURCE_ERROR_TIMEOUT", "3"),
    ("(gint) HINOKO_FW_SCODE_S100", "0"),
    ("(gint) HINOKO_FW_SCODE_S1600", "4"),
    ("(gint) HINOKO_FW_SCODE_S200", "1"),
    ("(gint) HINOKO_FW_SCODE_S3200", "5"),
    ("(gint) HINOKO_FW_SCODE_S400", "2"),
    ("(gint) HINOKO_FW_SCODE_S800", "3"),
];
