/*
 * $Id: dbiapi.h,v 1.40 1999/05/10 17:22:10 bob Exp $
 *
 * author:
 *      M.A. Borza, L. Hamid
 *      95.08.23
 *      DEW Engineering and Development Limited
 *      Ottawa, Ontario, Canada
 *      (c) Copyright 1995, all rights reserved.
 *
 * contents:
 *
 */

/* Change Log:
 *
 */


#ifndef _DBIAPI_H
#define _DBIAPI_H

#include "unixdefs.h"
#include "dbierrno.h"

#ifdef __cplusplus
extern "C" {
#endif 

#ifndef LOW_RES
#define LOW_RES
#endif

#ifdef HIGH_RES
#define  IMAGE_HEIGHT   320  
#define  IMAGE_WIDTH    320
#define DEW_TYPE huge
#endif /* HIGH_RES */

#ifdef LOW_RES
#define  IMAGE_HEIGHT   240  
#define  IMAGE_WIDTH    240

#ifndef _DOS
#define DEW_TYPE far
#else
#define DEW_TYPE __far 
#endif /* _DOS */

#endif /* LOW_RES */

#ifdef NIST_RES
#define  IMAGE_HEIGHT   512  
#define  IMAGE_WIDTH    512
#define DEW_TYPE huge
#endif /* NIST_RES */

/* This MAX_DIB stuff is for sizing bitmaps for displaying in windows. */
/* I would really like to get rid of this */
#if ((IMAGE_WIDTH * IMAGE_HEIGHT) > 65536L)
#define MAX_DIB_SIZE  32768L
#else
#define MAX_DIB_SIZE  ((DWORD)IMAGE_HEIGHT * (DWORD)IMAGE_WIDTH)
#endif
#define DIBWIDTHBYTES(bits)    (((bits) + 31) / 32 * 4)
#define MAX_DIB_ROWS  (MAX_DIB_SIZE / (DIBWIDTHBYTES ((DWORD)IMAGE_WIDTH * 8)))

#define FA_1_IN_500       0
#define FA_1_IN_1000      1
#define FA_1_IN_2500      2
#define FA_1_IN_5000      3
#define FA_1_IN_10000     4
#define FA_1_IN_25000     5
#define FA_1_IN_50000     6
#define FA_1_IN_100000    7
#define FA_1_IN_250000    8
#define FA_1_IN_500000    9
#define FA_1_IN_1000000   10

#define DBI_MAX_SAMPLES       10      /* Max number of samples for enrollment */
#define DBI_MAX_FINGER_ID     10

/* Bit flags indicating the quality of a finger print */
#define DBI_PRINT_NORMAL        0x0100
#define DBI_PRINT_DRY           0x0200
#define DBI_PRINT_VERY_DRY      0x0400
#define DBI_PRINT_MOIST         0x0800
#define DBI_PRINT_VERY_MOIST    0x1000

#define DBI_RND_LENG            21  /*Do 21-byte strings since this is the value supported by the scanner */
#define DBI_RND_COMMON          1   /*Noramal mode */
#define DBI_RND_UNIQUE          2   /*Each scanner is different */

/* Some Auto detection states */
#define DBI_PRINT_DETECTED   1
#define DBI_PRINT_STABILIZED 2   /* This is greater than DBI_PRINT_DETECTED on purpose */


/* GetInfo codes and return values */
#define DBI_BIOMOUSE_SERIAL      0
#define DBI_DRIVER_VERSION       1
#define DBI_RECOGNITION_VERSION  2

#define DBI_BIOMOUSE_MODEL       3
# define DBI_BIOMOUSE 0
# define DBI_BIOMOUSEPLUS 1

#define DBI_HARDWARE_ACCESS      4
# define DBI_DIRECT_ACCESS 0
# define DBI_DRIVER_ACCESS 1

#define DBI_HARDWARE_INTERFACE   5
# define DBI_DONGLE 0
# define DBI_PCCARD 1

#define DIT_SIZE 656

typedef unsigned char DIT; /* Device Independent Template */
typedef void DDT;          /* Device Dependent Template */
typedef unsigned char FImage;


DWORD ABC_DECL DBI_GrabPrintState( DWORD AutoOscillationThreshold,
                                 DWORD AutoStabilityThreshold,
                                 WORD  *AutoDetectionState);

DWORD ABC_DECL DBI_GrabImage (BYTE DEW_TYPE *Image, DWORD AutoOscillationThreshold,
                                                          DWORD AutoStabilityThreshold,
                                                          WORD *AutoDetectionState);

DWORD ABC_DECL DBI_CharacterizeImage (BYTE DEW_TYPE *Image, 
                                            BYTE DEW_TYPE *Buffer1, 
                                            BYTE DEW_TYPE *Buffer2, 
                                            DDT far *p, int *quality);

void ABC_DECL DBI_DLLInit (double length, BYTE dark_field);
DWORD ABC_DECL DBI_InitDriver(double *length, BYTE *dark_field);
void ABC_DECL DBI_CloseDriver(void);
DWORD ABC_DECL DBI_UnCompress_DIT(const DIT far *p, DDT far *q);
int ABC_DECL DBI_Compress_DIT(DDT far *p, DIT far *q);

long ABC_DECL DBI_Compare(DDT far *Ref, DDT far *Live);

DWORD ABC_DECL DBI_CompareDITs( const DIT far *pRefDit, 
                                const DIT far *pLiveDit, long *pScore );

int ABC_DECL DBI_Multi_Dim(long Scores[], int n_scores, int FArate);

int ABC_DECL DBI_EnrollPrint(DDT far *a[], int nsamples, int *maxsecurity);

#ifndef WIN32 
#include <memory.h>
#endif

size_t ABC_DECL DBI_sizeofDDT(void);
size_t ABC_DECL DBI_sizeofDIT(void);

DWORD ABC_DECL DBI_GetInfo( DWORD InfoType, DWORD *Info );
DWORD ABC_DECL DBI_Open(void);
void ABC_DECL DBI_Close(void);


DWORD ABC_DECL DBI_Randomize( unsigned char buffer[ DBI_RND_LENG ], int key_type );
DWORD ABC_DECL DBI_SquishDITs(DIT far *a[], int nDITs, BYTE *buffer, WORD buffersize);

WORD ABC_DECL DBI_sizeofSquishedDITs(DIT far *a[], int nDITs);
WORD ABC_DECL DBI_QuerySquishedDITs(BYTE *buffer, int *nDITs);
DWORD ABC_DECL DBI_UnSquishDITs(BYTE *buffer, DIT far *a[], int nDITs);

DWORD ABC_DECL DBI_SetLamp( BOOL On );

#ifdef __cplusplus
}
#endif 


#endif /* _DBIAPI_H */
