/* Copyright (C) 2002 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef __ERROR_CODES_H__
#define __ERROR_CODES_H__

/*
 * exit status values
 */

#define E_SUCCESS       0       /* success */
#define E_NOPERM        1       /* permission denied */
#define E_USAGE         2       /* invalid combination of options */
#define E_FAILURE       3       /* unexpected failure, nothing done */
#define E_MISSING       4       /* unexpected failure, passwd file missing */
#define E_PWDBUSY       5       /* passwd file busy, try again later */
#define E_BAD_ARG       6       /* invalid argument to option */
#define E_PAM_ERROR     7       /* PAM returns with an error */
#define E_NO_LOCAL_USER 8       /* The user is not in the local shadow file */

#define E_WRONG_VERSION 21	/* Protocol mismatch on server */
#define E_UNKNOWN_USER	22	/* User is not known on server */
#define E_SSL_FAILURE   23      /* SSL error, nothing done */

#endif

