#! /bin/bash
#
#  dkop-build.sh
#  compile and link with gtk+ library

g++ > /dev/null 2>&1
if [ $? -ne 1 ]
then
   echo "*** You must install the GCC compiler package"
   echo "    (C/C++ software development, g++ command)"
   exit 1
fi

pkg-config --cflags gtk+-2.0 --libs gtk+-2.0 gthread-2.0 > /dev/null 2>&1
if [ $? -ne 0 ]
then
   echo "*** You must install the GTK+ library package"
   echo "    (GNOME software development, gtk2.0 library)"
   exit 1
fi

g++ -O -Wall -o dkop.x  dkop.cpp zlib.cpp     \
    $(pkg-config --cflags gtk+-2.0 --libs gtk+-2.0 gthread-2.0)

if [ $? -eq 0 ]
then 
   echo "dkop build successful"
   chmod a+rx dkop.x
   chmod -R a+r *
   exit 0
fi

exit 1


