/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JComponent;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.gui.BlockPainter;
import org.biojava.bio.gui.LogoContext;
import org.biojava.bio.gui.LogoPainter;
import org.biojava.bio.gui.PlainBlock;
import org.biojava.bio.gui.PlainStyle;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.gui.TextLogoPainter;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class DistributionLogo
extends JComponent {
    private static final LogoPainter DEFAULT_LOGO_PAINTER = new TextLogoPainter();
    private static final BlockPainter DEFAULT_BLOCK_PAINTER = new PlainBlock();
    private static double bits = Math.log(2.0);
    private Distribution dist;
    private LogoPainter logoPainter = DEFAULT_LOGO_PAINTER;
    private SymbolStyle style = new PlainStyle(Color.black, Color.gray);
    boolean scaleByInformation = false;
    private BlockPainter blockPainter = DEFAULT_BLOCK_PAINTER;
    private RenderingHints renderingHints = null;

    public Distribution getDistribution() {
        return this.dist;
    }

    public void setDistribution(Distribution dist) throws IllegalAlphabetException {
        this.firePropertyChange("dist", this.dist, dist);
        this.dist = dist;
    }

    public LogoPainter getLogoPainter() {
        return this.logoPainter;
    }

    public void setLogoPainter(LogoPainter logoPainter) {
        this.firePropertyChange("logoPainter", this.logoPainter, logoPainter);
        this.logoPainter = logoPainter;
    }

    public SymbolStyle getStyle() {
        return this.style;
    }

    public void setStyle(SymbolStyle style) {
        this.firePropertyChange("style", this.style, style);
        this.style = style;
    }

    public boolean isScaleByInformation() {
        return this.scaleByInformation;
    }

    public void setScaleByInformation(boolean scale) {
        this.scaleByInformation = scale;
    }

    public BlockPainter getBlockPainter() {
        return this.blockPainter;
    }

    public void setBlockPainter(BlockPainter blockPainter) {
        this.blockPainter = blockPainter;
    }

    public DistributionLogo() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                String name = pce.getPropertyName();
                if (name.equals("dist") || name.equals("logoPainter") || name.equals("style")) {
                    DistributionLogo.this.repaint();
                }
            }
        });
        Dimension d = new Dimension(20, 20);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
    }

    public static double entropy(Distribution dist, Symbol s) throws IllegalSymbolException {
        double p = dist.getWeight(s);
        if (p == 0.0) {
            return 0.0;
        }
        double lp = Math.log(p);
        return -p * lp / bits;
    }

    public static double totalBits(Distribution dist) {
        return Math.log(((FiniteAlphabet)dist.getAlphabet()).size()) / bits;
    }

    public static double totalInformation(Distribution dist) {
        double inf = DistributionLogo.totalBits(dist);
        Iterator i = ((FiniteAlphabet)dist.getAlphabet()).iterator();
        while (i.hasNext()) {
            Symbol s = (Symbol)i.next();
            try {
                inf -= DistributionLogo.entropy(dist, s);
            }
            catch (IllegalSymbolException ire) {
                throw new BioError("Symbol evaporated while calculating information", ire);
            }
        }
        return inf;
    }

    public void paintComponent(Graphics g) {
        final Graphics2D g2 = (Graphics2D)g;
        if (this.renderingHints != null) {
            g2.setRenderingHints(this.renderingHints);
        }
        Rectangle clip = g2.getClipBounds();
        if (this.isOpaque()) {
            g2.clearRect(clip.x, clip.y, clip.width, clip.height);
        }
        if (this.getDistribution() == null) {
            return;
        }
        final Rectangle bounds = this.getBounds();
        if (this.isScaleByInformation()) {
            int height = bounds.height;
            double scale = (double)height * (DistributionLogo.totalInformation(this.getDistribution()) / DistributionLogo.totalBits(this.getDistribution()));
            bounds.height = (int)scale;
            bounds.y = (int)((double)height - scale);
        }
        LogoContext ctxt = new LogoContext(){

            public Graphics2D getGraphics() {
                return g2;
            }

            public Distribution getDistribution() {
                return DistributionLogo.this.getDistribution();
            }

            public Rectangle getBounds() {
                return bounds;
            }

            public SymbolStyle getStyle() {
                return DistributionLogo.this.getStyle();
            }

            public BlockPainter getBlockPainter() {
                return DistributionLogo.this.getBlockPainter();
            }
        };
        this.getLogoPainter().paintLogo(ctxt);
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = renderingHints;
    }
}

