/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das.dasalignment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.program.das.dasalignment.DASException;

public class Alignment {
    ArrayList objects = new ArrayList();
    ArrayList scores = new ArrayList();
    ArrayList blocks = new ArrayList();

    public void addObject(HashMap object) throws DASException {
        this.checkObjectHash(object);
        this.objects.add(object);
    }

    public ArrayList getObjects() {
        return this.objects;
    }

    public void addScore(HashMap score) throws DASException {
        this.checkScoreHash(score);
    }

    public ArrayList getScores() {
        return this.scores;
    }

    public void addBlock(ArrayList segment) throws DASException {
        this.checkBlockList(segment);
        this.blocks.add(segment);
    }

    public ArrayList getBlocks() {
        return this.blocks;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.objects.size(); ++i) {
            HashMap object = (HashMap)this.objects.get(i);
            str = str + "object: " + (String)object.get("id") + "\n";
        }
        str = str + "number of blocks: " + this.blocks.size();
        return str;
    }

    private void checkObjectHash(HashMap object) throws DASException {
        Alignment.validateMap(object, new Object[]{"id", "version", "type", "coordinateSystem"});
    }

    private void checkScoreHash(HashMap score) throws DASException {
        Alignment.validateMap(score, new Object[]{"scorename", "scorevalue"});
    }

    private void checkBlockList(ArrayList block) throws DASException {
        for (int i = 0; i < block.size(); ++i) {
            HashMap member = (HashMap)block.get(i);
            Alignment.validateMap(member, new Object[]{"id", "start", "end"});
        }
    }

    static void validateMap(Map m, Object[] requiredKeys) throws DASException {
        for (int i = 0; i < requiredKeys.length; ++i) {
            if (m.containsKey(requiredKeys[i])) continue;
            throw new DASException("Required key >" + requiredKeys[i] + "< is not present");
        }
    }
}

