/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das.dasalignment;

import java.util.ArrayList;
import java.util.HashMap;
import org.biojava.bio.program.das.dasalignment.Alignment;
import org.biojava.bio.program.das.dasalignment.DASException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class DASAlignmentXMLResponseParser
extends DefaultHandler {
    ArrayList alignments;
    Alignment alignment;
    HashMap current_object;
    String current_position;
    ArrayList current_block;
    HashMap current_segment;

    public DASAlignmentXMLResponseParser() {
        System.out.println("init DASAlignmentXMLResponseParser");
        this.alignment = new Alignment();
        this.current_position = "start";
        this.alignments = new ArrayList();
    }

    public ArrayList getAlignments() {
        return this.alignments;
    }

    public Alignment getAlignment(int position) {
        Alignment ra = (Alignment)this.alignments.get(position);
        return ra;
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (qName.equals("OBJECT")) {
            this.OBJECThandler(atts);
        }
        if (qName.equals("DESCRIPTION")) {
            this.DESCRIPTIONhandler(atts);
        }
        if (qName.equals("SEQUENCE")) {
            this.SEQUENCEhandler(atts);
        }
        if (qName.equals("SCORE")) {
            this.SCOREhandler(atts);
        }
        if (qName.equals("BLOCK")) {
            this.BLOCKhandler(atts);
        }
        if (qName.equals("SEGMENT")) {
            this.SEGMENThandler(atts);
        }
        if (qName.equals("CIGAR")) {
            this.CIGARhandler(atts);
        }
        if (qName.equals("GEO3D")) {
            this.GEO3Dhandler(atts);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("OBJECT")) {
            try {
                this.alignment.addObject(this.current_object);
            }
            catch (DASException e) {
                e.printStackTrace();
            }
            this.current_object = new HashMap();
        }
        if (qName.equals("SEGMENT")) {
            this.current_block.add(this.current_segment);
            this.current_segment = new HashMap();
        }
        if (qName.equals("BLOCK")) {
            try {
                this.alignment.addBlock(this.current_block);
            }
            catch (DASException e) {
                e.printStackTrace();
            }
            this.current_block = new ArrayList();
        }
        if (qName.equals("ALIGNMENT")) {
            this.alignments.add(this.alignment);
            this.alignment = new Alignment();
        }
    }

    private void SEGMENThandler(Attributes atts) {
        this.current_position = "segment";
        this.current_segment = new HashMap();
        String id = atts.getValue("id");
        String start = atts.getValue("start");
        String end = atts.getValue("end");
        this.current_segment.put("id", id);
        this.current_segment.put("start", start);
        this.current_segment.put("end", end);
    }

    private void CIGARhandler(Attributes atts) {
        this.current_position = "cigar";
    }

    private void BLOCKhandler(Attributes atts) {
        this.current_block = new ArrayList();
    }

    private void DESCRIPTIONhandler(Attributes atts) {
        this.current_position = "description";
    }

    private void SEQUENCEhandler(Attributes atts) {
        this.current_position = "sequence";
    }

    private void SCOREhandler(Attributes atts) {
        System.out.println("SCOREhandler not implemented,yet...");
    }

    private void GEO3Dhandler(Attributes atts) {
        System.out.println("GEO3D not implemented,yet...");
    }

    private void OBJECThandler(Attributes atts) {
        String id = atts.getValue("id");
        String coordinateSystem = atts.getValue("coordinateSystem");
        String version = atts.getValue("version");
        String type = atts.getValue("type");
        HashMap<String, String> object = new HashMap<String, String>();
        object.put("id", id);
        object.put("coordinateSystem", coordinateSystem);
        object.put("version", version);
        object.put("type", type);
        this.current_object = object;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void characters(char[] ch, int start, int length) {
        String txt = "";
        for (int i = start; i < start + length; ++i) {
            txt = txt + ch[i];
        }
        if (this.current_position == "description") {
            this.current_object.put("description", txt);
        } else if (this.current_position == "sequence") {
            this.current_object.put("sequence", txt);
        } else if (this.current_position == "cigar") {
            this.current_segment.put("cigarstring", txt);
        }
    }
}

