/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.FastaSearchParser;
import org.biojava.bio.program.sax.QName;
import org.biojava.bio.search.SearchContentHandler;
import org.biojava.utils.ParserException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FastaSearchSAXParser
extends AbstractNativeAppSAXParser
implements SearchContentHandler {
    private FastaSearchParser fastaParser;
    private Map searchProperties;
    private Map hitProperties;
    private String queryID;
    private String databaseID;
    private AttributesImpl attributes;
    private QName qName;
    private boolean firstHit = true;
    private boolean moreSearchesAvailable = true;
    private NumberFormat nFormat;
    private String nl;
    private StringBuffer props;
    private StringBuffer seqTokens;
    private String stringOut;
    private char[] charOut;

    public FastaSearchSAXParser() {
        this.setNamespacePrefix("biojava");
        this.addPrefixMapping("biojava", "http://www.biojava.org");
        this.fastaParser = new FastaSearchParser();
        this.attributes = new AttributesImpl();
        this.qName = new QName(this);
        this.nFormat = new DecimalFormat("###.0");
        this.props = new StringBuffer(1024);
        this.seqTokens = new StringBuffer(2048);
        this.nl = System.getProperty("line.separator");
    }

    public void parse(InputSource source) throws IOException, SAXException {
        BufferedReader content = this.getContentStream(source);
        if (this.oHandler == null) {
            throw new SAXException("Running FastaSearchSAXParser with null ContentHandler");
        }
        try {
            this.attributes.clear();
            this.qName.setQName("xmlns");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", "");
            this.qName.setQName("xmlns:biojava");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", "http://www.biojava.org");
            this.startElement(new QName(this, this.prefix("BlastLikeDataSetCollection")), this.attributes);
            while (this.moreSearchesAvailable) {
                this.fastaParser.parseSearch(content, this);
            }
            this.endElement(new QName(this, this.prefix("BlastLikeDataSetCollection")));
        }
        catch (BioException be) {
            throw new SAXException(be);
        }
        catch (ParserException pe) {
            throw new SAXException(pe);
        }
    }

    public boolean getMoreSearches() {
        return this.moreSearchesAvailable;
    }

    public void setMoreSearches(boolean value) {
        this.moreSearchesAvailable = value;
    }

    public void setQuerySeq(String identifier) {
        this.setQueryID(identifier);
    }

    public void setQueryID(String queryID) {
        this.queryID = queryID;
    }

    public void setSubjectDB(String identifier) {
        this.setDatabaseID(identifier);
    }

    public void setDatabaseID(String databaseID) {
        this.databaseID = databaseID;
    }

    public void startSearch() {
        this.searchProperties = new HashMap();
    }

    public void addSearchProperty(Object key, Object value) {
        this.searchProperties.put(key, value);
    }

    public void endSearch() {
        try {
            if (!this.firstHit) {
                this.endElement(new QName(this, this.prefix("Detail")));
                this.firstHit = true;
            }
            this.endElement(new QName(this, this.prefix("BlastLikeDataSet")));
        }
        catch (SAXException se) {
            System.err.println("An error occurred while creating an endElement SAX event: ");
            se.printStackTrace();
        }
    }

    public void startHeader() {
    }

    public void endHeader() {
        try {
            this.attributes.clear();
            this.qName.setQName("program");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", (String)this.searchProperties.get("pg_name"));
            this.qName.setQName("version");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", (String)this.searchProperties.get("pg_ver"));
            this.startElement(new QName(this, this.prefix("BlastLikeDataSet")), this.attributes);
            this.attributes.clear();
            this.startElement(new QName(this, this.prefix("Header")), this.attributes);
            this.attributes.clear();
            this.qName.setQName("id");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", this.queryID);
            this.qName.setQName("metaData");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", "none");
            this.startElement(new QName(this, this.prefix("QueryId")), this.attributes);
            this.endElement(new QName(this, this.prefix("QueryId")));
            this.attributes.clear();
            this.qName.setQName("id");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", this.databaseID);
            this.qName.setQName("metaData");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", "none");
            this.startElement(new QName(this, this.prefix("DatabaseId")), this.attributes);
            this.endElement(new QName(this, this.prefix("DatabaseId")));
            this.attributes.clear();
            this.qName.setQName("xml:space");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", "preserve");
            this.startElement(new QName(this, this.prefix("RawOutput")), this.attributes);
            Set spKeys = this.searchProperties.keySet();
            Object[] searchPropKeys = spKeys.toArray(new String[spKeys.size() - 1]);
            Arrays.sort(searchPropKeys);
            this.props.setLength(0);
            this.props.append(this.nl);
            for (int i = 0; i < searchPropKeys.length; ++i) {
                this.props.append((String)searchPropKeys[i] + ": ");
                this.props.append((String)this.searchProperties.get(searchPropKeys[i]) + this.nl);
            }
            this.charOut = new char[this.props.length()];
            this.props.getChars(0, this.props.length(), this.charOut, 0);
            this.characters(this.charOut, 0, this.charOut.length);
            this.endElement(new QName(this, this.prefix("RawOutput")));
            this.endElement(new QName(this, this.prefix("Header")));
        }
        catch (SAXException se) {
            System.err.println("An error occurred while creating SAX events from header data: ");
            se.printStackTrace();
        }
    }

    public void startHit() {
        if (this.firstHit) {
            this.firstHit = false;
            this.attributes.clear();
            try {
                this.startElement(new QName(this, this.prefix("Detail")), this.attributes);
            }
            catch (SAXException se) {
                System.err.println("An error occurred while creating startElement SAX event from hit data: ");
                se.printStackTrace();
            }
        }
        this.hitProperties = new HashMap();
    }

    public void addHitProperty(Object key, Object value) {
        this.hitProperties.put(key, value);
    }

    public void endHit() {
    }

    public void startSubHit() {
    }

    public void addSubHitProperty(Object key, Object value) {
        this.hitProperties.put(key, value);
    }

    /*
     * WARNING - void declaration
     */
    public void endSubHit() {
        this.attributes.clear();
        this.qName.setQName("sequenceLength");
        this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", (String)this.hitProperties.get("subject_sq_len"));
        try {
            void var2_3;
            String overlap;
            this.startElement(new QName(this, this.prefix("Hit")), this.attributes);
            this.attributes.clear();
            this.qName.setQName("id");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", (String)this.hitProperties.get("id"));
            this.qName.setQName("metaData");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", "none");
            this.startElement(new QName(this, this.prefix("HitId")), this.attributes);
            this.endElement(new QName(this, this.prefix("HitId")));
            this.attributes.clear();
            this.startElement(new QName(this, this.prefix("HitDescription")), this.attributes);
            this.stringOut = (String)this.hitProperties.get("desc");
            this.charOut = new char[this.stringOut.length()];
            this.stringOut.getChars(0, this.stringOut.length(), this.charOut, 0);
            this.characters(this.charOut, 0, this.charOut.length);
            this.endElement(new QName(this, this.prefix("HitDescription")));
            this.startElement(new QName(this, this.prefix("HSPCollection")), this.attributes);
            this.startElement(new QName(this, this.prefix("HSP")), this.attributes);
            if (!this.hitProperties.containsKey("fa_z-score")) {
                throw new SAXException("Failed to retrieve hit z-score from search data");
            }
            String score = (String)this.hitProperties.get("fa_z-score");
            this.qName.setQName("score");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", score);
            this.qName.setQName("expectValue");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", (String)this.hitProperties.get("fa_expect"));
            this.qName.setQName("numberOfIdentities");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", this.countTokens(':', (String)this.hitProperties.get("matchTokens")));
            if (this.hitProperties.containsKey("fa_overlap")) {
                overlap = this.hitProperties.get("fa_overlap").toString();
            } else if (this.hitProperties.containsKey("sw_overlap")) {
                overlap = this.hitProperties.get("sw_overlap").toString();
            } else {
                throw new SAXException("Failed to retrieve hit overlap from search data");
            }
            this.qName.setQName("alignmentSize");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", (String)var2_3);
            float percentId = this.hitProperties.containsKey("fa_ident") ? Float.parseFloat((String)this.hitProperties.get("fa_ident")) : Float.parseFloat((String)this.hitProperties.get("sw_ident"));
            this.qName.setQName("percentageIdentity");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", this.nFormat.format(percentId * 100.0f));
            String seqType = this.hitProperties.get("query_sq_type").equals("dna") ? "dna" : "protein";
            this.qName.setQName("querySequenceType");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", seqType);
            seqType = this.hitProperties.get("subject_sq_type").equals("dna") ? "dna" : "protein";
            this.qName.setQName("hitSequenceType");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", seqType);
            if (seqType.equals("dna")) {
                this.qName.setQName("queryStrand");
                this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", "plus");
                String strand = this.hitProperties.get("fa_frame").equals("f") ? "plus" : "minus";
                this.qName.setQName("hitStrand");
                this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", strand);
            }
            this.startElement(new QName(this, this.prefix("HSPSummary")), this.attributes);
            this.attributes.clear();
            this.startElement(new QName(this, this.prefix("RawOutput")), this.attributes);
            Set hpKeys = this.hitProperties.keySet();
            Object[] hitPropKeys = hpKeys.toArray(new String[hpKeys.size() - 1]);
            Arrays.sort(hitPropKeys);
            this.props.setLength(0);
            this.props.append(this.nl);
            for (int i = 0; i < hitPropKeys.length; ++i) {
                if (((String)hitPropKeys[i]).endsWith("Tokens")) continue;
                this.props.append((String)hitPropKeys[i] + ": ");
                this.props.append((String)this.hitProperties.get(hitPropKeys[i]) + this.nl);
            }
            this.charOut = new char[this.props.length()];
            this.props.getChars(0, this.props.length(), this.charOut, 0);
            this.characters(this.charOut, 0, this.charOut.length);
            this.endElement(new QName(this, this.prefix("RawOutput")));
            this.endElement(new QName(this, this.prefix("HSPSummary")));
            this.startElement(new QName(this, this.prefix("BlastLikeAlignment")), this.attributes);
            String alStart = (String)this.hitProperties.get("query_al_start");
            String alStop = (String)this.hitProperties.get("query_al_stop");
            String alDispStart = (String)this.hitProperties.get("query_al_display_start");
            this.qName.setQName("startPosition");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", alStart);
            this.qName.setQName("stopPosition");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", alStop);
            this.startElement(new QName(this, this.prefix("QuerySequence")), this.attributes);
            this.seqTokens.setLength(0);
            this.seqTokens.append((String)this.hitProperties.get("querySeqTokens"));
            this.stringOut = this.prepSeqTokens(this.seqTokens, Integer.parseInt(alStart), Integer.parseInt(alStop), Integer.parseInt(alDispStart));
            this.charOut = new char[this.stringOut.length()];
            this.stringOut.getChars(0, this.stringOut.length(), this.charOut, 0);
            this.characters(this.charOut, 0, this.charOut.length);
            this.endElement(new QName(this, this.prefix("QuerySequence")));
            this.attributes.clear();
            this.qName.setQName("xml:space");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", "preserve");
            this.startElement(new QName(this, this.prefix("MatchConsensus")), this.attributes);
            this.stringOut = ((String)this.hitProperties.get("matchTokens")).trim();
            this.charOut = new char[this.stringOut.length()];
            this.stringOut.getChars(0, this.stringOut.length(), this.charOut, 0);
            this.characters(this.charOut, 0, this.charOut.length);
            this.endElement(new QName(this, this.prefix("MatchConsensus")));
            alStart = (String)this.hitProperties.get("subject_al_start");
            alStop = (String)this.hitProperties.get("subject_al_stop");
            alDispStart = (String)this.hitProperties.get("subject_al_display_start");
            this.attributes.clear();
            this.qName.setQName("startPosition");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", alStart);
            this.qName.setQName("stopPosition");
            this.attributes.addAttribute(this.qName.getURI(), this.qName.getLocalName(), this.qName.getQName(), "CDATA", alStop);
            this.startElement(new QName(this, this.prefix("HitSequence")), this.attributes);
            this.seqTokens.setLength(0);
            this.seqTokens.append((String)this.hitProperties.get("subjectSeqTokens"));
            this.stringOut = this.prepSeqTokens(this.seqTokens, Integer.parseInt(alStart), Integer.parseInt(alStop), Integer.parseInt(alDispStart));
            this.charOut = new char[this.stringOut.length()];
            this.stringOut.getChars(0, this.stringOut.length(), this.charOut, 0);
            this.characters(this.charOut, 0, this.charOut.length);
            this.endElement(new QName(this, this.prefix("HitSequence")));
            this.endElement(new QName(this, this.prefix("BlastLikeAlignment")));
            this.endElement(new QName(this, this.prefix("HSP")));
            this.endElement(new QName(this, this.prefix("HSPCollection")));
            this.endElement(new QName(this, this.prefix("Hit")));
        }
        catch (SAXException se) {
            System.err.println("An error occurred while creating SAX events from hit data: ");
            se.printStackTrace();
        }
    }

    private String countTokens(char token, String string) {
        int count = 0;
        int i = string.length();
        while (--i >= 0) {
            if (string.charAt(i) != token) continue;
            ++count;
        }
        return String.valueOf(count);
    }

    private String prepSeqTokens(StringBuffer seqTokens, int alStart, int alStop, int alDispStart) {
        while (seqTokens.charAt(0) == '-') {
            seqTokens.deleteCharAt(0);
        }
        int gapCount = 0;
        int i = seqTokens.length();
        while (--i >= 0) {
            if (seqTokens.charAt(i) != '-') continue;
            ++gapCount;
        }
        return seqTokens.substring(alStart - alDispStart, alStop - alDispStart + gapCount + 1);
    }
}

