/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.AtomIterator;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;

public class Calc {
    static double RADIAN = 57.29577951;

    public static double getDistance(Atom a, Atom b) throws StructureException {
        Atom c = Calc.substract(b, a);
        double dist = Calc.amount(c);
        return dist;
    }

    private static void nullCheck(Atom a) throws StructureException {
        if (a == null) {
            throw new StructureException("Atom is null!");
        }
    }

    public static Atom add(Atom a, Atom b) {
        double[] coords = new double[]{a.getX() + b.getX(), a.getY() + b.getY(), a.getZ() + b.getZ()};
        AtomImpl c = new AtomImpl();
        c.setCoords(coords);
        return c;
    }

    public static Atom substract(Atom a, Atom b) throws StructureException {
        Calc.nullCheck(a);
        Calc.nullCheck(b);
        double[] coords = new double[]{a.getX() - b.getX(), a.getY() - b.getY(), a.getZ() - b.getZ()};
        AtomImpl c = new AtomImpl();
        c.setCoords(coords);
        return c;
    }

    public static Atom vectorProduct(Atom a, Atom b) {
        double[] coords = new double[]{a.getY() * b.getZ() - a.getZ() * b.getY(), a.getZ() * b.getX() - a.getX() * b.getZ(), a.getX() * b.getY() - a.getY() * b.getX()};
        AtomImpl c = new AtomImpl();
        c.setCoords(coords);
        return c;
    }

    public static double skalarProduct(Atom a, Atom b) {
        double skalar = a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ();
        return skalar;
    }

    public static double amount(Atom a) {
        return Math.sqrt(Calc.skalarProduct(a, a));
    }

    public static double angle(Atom a, Atom b) {
        double skalar = Calc.skalarProduct(a, b);
        double angle = skalar / (Calc.amount(a) * Calc.amount(b));
        angle = Math.acos(angle);
        return angle *= RADIAN;
    }

    public static Atom unitVector(Atom a) {
        double amount = Calc.amount(a);
        Atom U = a;
        double[] coords = new double[]{a.getX() / amount, a.getY() / amount, a.getZ() / amount};
        U.setCoords(coords);
        return U;
    }

    public static double torsionAngle(Atom a, Atom b, Atom c, Atom d) throws StructureException {
        Atom ab = Calc.substract(a, b);
        Atom cb = Calc.substract(c, b);
        Atom bc = Calc.substract(b, c);
        Atom dc = Calc.substract(d, c);
        Atom abc = Calc.vectorProduct(ab, cb);
        Atom bcd = Calc.vectorProduct(bc, dc);
        double angl = Calc.angle(abc, bcd);
        Atom vecprod = Calc.vectorProduct(abc, bcd);
        double val = Calc.skalarProduct(cb, vecprod);
        if (val < 0.0) {
            angl = -angl;
        }
        return angl;
    }

    public static double getPhi(AminoAcid a, AminoAcid b) throws StructureException {
        if (!Calc.isConnected(a, b)) {
            throw new StructureException("can not calc Phi - AminoAcids are not connected!");
        }
        Atom a_C = a.getC();
        Atom b_N = b.getN();
        Atom b_CA = b.getCA();
        Atom b_C = b.getC();
        double phi = Calc.torsionAngle(a_C, b_N, b_CA, b_C);
        return phi;
    }

    public static double getPsi(AminoAcid a, AminoAcid b) throws StructureException {
        if (!Calc.isConnected(a, b)) {
            throw new StructureException("can not calc Psi - AminoAcids are not connected!");
        }
        Atom a_N = a.getN();
        Atom a_CA = a.getCA();
        Atom a_C = a.getC();
        Atom b_N = b.getN();
        double psi = Calc.torsionAngle(a_N, a_CA, a_C, b_N);
        return psi;
    }

    public static boolean isConnected(AminoAcid a, AminoAcid b) throws StructureException {
        Atom N;
        Atom C = a.getC();
        double distance = Calc.getDistance(C, N = b.getN());
        return distance < 2.5;
    }

    public static void rotate(Structure structure, double[][] m) throws StructureException {
        if (m.length != 3) {
            throw new StructureException("matrix does not have size 3x3 !");
        }
        AtomIterator iter = new AtomIterator(structure);
        while (iter.hasNext()) {
            Atom atom = (Atom)iter.next();
            double x = atom.getX();
            double y = atom.getY();
            double z = atom.getZ();
            double nx = m[0][0] * x + m[0][1] * y + m[0][2] * z;
            double ny = m[1][0] * x + m[1][1] * y + m[1][2] * z;
            double nz = m[2][0] * x + m[2][1] * y + m[2][2] * z;
            double[] coords = new double[]{nx, ny, nz};
            atom.setCoords(coords);
        }
    }

    public static void shift(Structure structure, Atom a) {
        AtomIterator iter = new AtomIterator(structure);
        while (iter.hasNext()) {
            Atom atom = (Atom)iter.next();
            Atom atom2 = Calc.add(atom, a);
        }
    }
}

