/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.GappedSymbolList;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AssertionFailure;

public class SimpleGappedSymbolList
extends AbstractSymbolList
implements GappedSymbolList,
Serializable {
    private final Alphabet alpha;
    private final SymbolList source;
    private final ArrayList blocks;
    private int length;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected final int findSourceBlock(int indx) {
        int i = this.blocks.size() / 2;
        int imin = 0;
        int imax = this.blocks.size() - 1;
        do {
            Block b = (Block)this.blocks.get(i);
            if (b.sourceStart <= indx && b.sourceEnd >= indx) {
                return i;
            }
            if (b.sourceStart < indx) {
                imin = i + 1;
                i = imin + (imax - imin) / 2;
                continue;
            }
            imax = i - 1;
            i = imin + (imax - imin) / 2;
        } while (imin <= imax);
        throw new BioError("Something is screwed. Could not find source block containing index " + indx + " in sequence of length " + this.source.length());
    }

    protected final int findViewBlock(int indx) {
        Block b;
        int i = this.blocks.size() / 2;
        int imin = 0;
        int imax = this.blocks.size() - 1;
        do {
            b = (Block)this.blocks.get(i);
            if (b.viewStart <= indx && b.viewEnd >= indx) {
                return i;
            }
            if (b.viewStart < indx) {
                imin = i + 1;
                i = imin + (imax - imin) / 2;
                continue;
            }
            imax = i - 1;
            i = imin + (imax - imin) / 2;
        } while (imin <= imax);
        if (i >= this.blocks.size()) {
            return -this.blocks.size() - 1;
        }
        if (this.blocks.get(i) != b) {
            if (this.blocks.get(i - 1) == b) {
                --i;
            } else if (this.blocks.get(i + 1) == b) {
                ++i;
            }
        }
        if (indx <= b.viewStart || ++i < this.blocks.size()) {
            // empty if block
        }
        return -i - 1;
    }

    protected final int findSourceGap(int indx) {
        Block b;
        int i = this.blocks.size() / 2;
        int imin = 0;
        int imax = this.blocks.size() - 1;
        do {
            b = (Block)this.blocks.get(i);
            if (b.sourceStart <= indx && b.sourceEnd >= indx) {
                return -1;
            }
            if (b.sourceStart < indx) {
                imin = i + 1;
                i = imin + (imax - imin) / 2;
                continue;
            }
            imax = i - 1;
            i = imin + (imax - imin) / 2;
        } while (imin <= imax);
        b = (Block)this.blocks.get(i);
        if (b.viewEnd < indx) {
            return i;
        }
        return i - 1;
    }

    protected final int findViewGap(int indx) {
        Block b;
        int i = this.blocks.size() / 2;
        int imin = 0;
        int imax = this.blocks.size() - 1;
        do {
            b = (Block)this.blocks.get(i);
            if (b.viewStart <= indx && b.viewEnd >= indx) {
                return -2;
            }
            if (b.viewStart < indx) {
                imin = i + 1;
                i = imin + (imax - imin) / 2;
                continue;
            }
            imax = i - 1;
            i = imin + (imax - imin) / 2;
        } while (imin <= imax);
        if (i < this.blocks.size()) {
            b = (Block)this.blocks.get(i);
            if (b.viewEnd < indx) {
                return i;
            }
            return i - 1;
        }
        return i - 1;
    }

    protected final int viewToSource(Block b, int indx) {
        return indx - b.viewStart + b.sourceStart;
    }

    public final int viewToSource(int indx) throws IndexOutOfBoundsException {
        if (indx < 1 || indx > this.length()) {
            throw new IndexOutOfBoundsException("Attempted to address sequence (1.." + this.length() + ") at " + indx);
        }
        int j = this.findViewBlock(indx);
        if (j < 0) {
            int nj = -j - 1;
            if (nj < this.blocks.size()) {
                Block b = (Block)this.blocks.get(nj);
                return -b.sourceStart;
            }
            return -(this.source.length() + 1);
        }
        return this.viewToSource((Block)this.blocks.get(j), indx);
    }

    protected final int sourceToView(Block b, int indx) {
        return indx - b.sourceStart + b.viewStart;
    }

    public final int sourceToView(int indx) throws IndexOutOfBoundsException {
        if (indx < 1 || indx > this.source.length()) {
            throw new IndexOutOfBoundsException("Attempted to address source sequence (1.." + this.length() + ") at " + indx);
        }
        int j = this.findSourceBlock(indx);
        return this.sourceToView((Block)this.blocks.get(j), indx);
    }

    protected final void renumber(int i, int delta) {
        for (int j = i; j < this.blocks.size(); ++j) {
            Block b = (Block)this.blocks.get(j);
            b.viewStart += delta;
            b.viewEnd += delta;
        }
        this.length += delta;
    }

    public void addGapInView(int pos) throws IndexOutOfBoundsException {
        this.addGapsInView(pos, 1);
    }

    public void addGapsInView(int pos, int length) throws IndexOutOfBoundsException {
        Block b;
        if (pos < 1 || pos > this.length() + 1) {
            throw new IndexOutOfBoundsException("Attempted to add a gap outside of this sequence (1.." + this.length() + ") at " + pos);
        }
        int i = this.blocks.size() / 2;
        int imin = 0;
        int imax = this.blocks.size() - 1;
        do {
            b = (Block)this.blocks.get(i);
            if (b.viewStart < pos && b.viewEnd >= pos) {
                Block c = new Block(this.viewToSource(b, pos), b.sourceEnd, pos, b.viewEnd);
                b.viewEnd = pos - 1;
                b.sourceEnd = this.viewToSource(b, pos - 1);
                this.blocks.add(i + 1, c);
                this.renumber(i + 1, length);
                return;
            }
            if (b.viewStart < pos) {
                imin = i + 1;
                i = imin + (imax - imin) / 2;
                continue;
            }
            imax = i - 1;
            i = imin + (imax - imin) / 2;
        } while (imin <= imax);
        if (i < this.blocks.size()) {
            b = (Block)this.blocks.get(i);
            if (pos <= b.viewStart) {
                --i;
            }
        } else {
            --i;
        }
        this.renumber(i + 1, length);
    }

    public void addGapInSource(int pos) throws IndexOutOfBoundsException {
        this.addGapsInSource(pos, 1);
    }

    public void addGapsInSource(int pos, int length) {
        Block b;
        if (pos < 1 || pos > this.length() + 1) {
            throw new IndexOutOfBoundsException("Attempted to add a gap outside of this sequence (1.." + this.length() + ") at " + pos);
        }
        int i = this.blocks.size() / 2;
        int imin = 0;
        int imax = this.blocks.size() - 1;
        do {
            b = (Block)this.blocks.get(i);
            if (b.sourceStart < pos && b.sourceEnd >= pos) {
                Block c = new Block(pos, b.sourceEnd, this.sourceToView(b, pos), b.viewEnd);
                b.viewEnd = this.sourceToView(b, pos - 1);
                b.sourceEnd = pos - 1;
                this.blocks.add(i + 1, c);
                this.renumber(i + 1, length);
                return;
            }
            if (b.sourceStart < pos) {
                imin = i + 1;
                i = imin + (imax - imin) / 2;
                continue;
            }
            imax = i - 1;
            i = imin + (imax - imin) / 2;
        } while (imin <= imax);
        if (i < this.blocks.size()) {
            b = (Block)this.blocks.get(i);
            if (b.sourceStart <= pos) {
                --i;
            }
        }
        this.renumber(i + 1, length);
        if (!$assertionsDisabled && !this.isSane()) {
            throw new AssertionError((Object)("Data corrupted: " + this.blocks));
        }
    }

    public void removeGap(int pos) throws IndexOutOfBoundsException, IllegalSymbolException {
        if (pos < 1 || pos > this.length()) {
            throw new IndexOutOfBoundsException("Attempted to remove gap outside of this sequence (1.." + this.length() + ") at " + pos);
        }
        int i = this.findViewGap(pos);
        if (i == -2) {
            throw new IllegalSymbolException("Attempted to remove a gap at a non-gap index: " + pos + " -> " + this.symbolAt(pos).getName());
        }
        if (i == -1 || i == this.blocks.size() - 1) {
            this.renumber(i + 1, -1);
        } else {
            Block l = (Block)this.blocks.get(i);
            Block r = (Block)this.blocks.get(i + 1);
            this.renumber(i + 1, -1);
            int gap = r.viewStart - l.viewEnd;
            if (gap == 1) {
                l.sourceEnd = r.sourceEnd;
                l.viewEnd = r.viewEnd;
                this.blocks.remove(i + 1);
            }
        }
        if (!$assertionsDisabled && !this.isSane()) {
            throw new AssertionError((Object)("Data corrupted: " + this.blocks));
        }
    }

    public void removeGaps(int pos, int length) throws IndexOutOfBoundsException, IllegalSymbolException {
        int end = pos + length - 1;
        if (pos < 1 || length < 1 || end > this.length()) {
            throw new IndexOutOfBoundsException("Attempted to remove gap outside of this sequence (1.." + this.length() + ") at (" + pos + ".." + end + ")");
        }
        int i = this.findViewGap(pos);
        if (i == -2) {
            throw new IllegalSymbolException("Attempted to remove a gap at a non-gap index: " + pos + " -> " + this.symbolAt(pos).getName());
        }
        if (i == -1) {
            Block b = (Block)this.blocks.get(0);
            if (b.viewStart <= end) {
                throw new IllegalSymbolException("Attempted to remove some non-gap characters at (" + pos + ".." + end + ")");
            }
            this.renumber(i + 1, -length);
        } else if (i == this.blocks.size() - 1) {
            this.length -= length;
        } else {
            Block l = (Block)this.blocks.get(i);
            Block r = (Block)this.blocks.get(i + 1);
            int gap = r.viewStart - l.viewEnd;
            if (gap < length) {
                throw new IllegalSymbolException("Removing " + length + " gaps from + " + i + " but there are only " + gap + " gaps there: " + this.blocks);
            }
            this.renumber(i + 1, -length);
            if (gap == length) {
                l.sourceEnd = r.sourceEnd;
                l.viewEnd = r.viewEnd;
                this.blocks.remove(i + 1);
            }
        }
        if (!$assertionsDisabled && !this.isSane()) {
            throw new AssertionError((Object)("Data corrupted: removeGaps(" + pos + "," + length + ") " + this.blocks));
        }
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public int length() {
        return this.length;
    }

    public Symbol symbolAt(int indx) throws IndexOutOfBoundsException {
        if (indx > this.length() || indx < 1) {
            throw new IndexOutOfBoundsException("Attempted to read outside of this sequence (1.." + this.length() + ") at " + indx);
        }
        int i = this.findViewBlock(indx);
        if (i < 0) {
            if (indx < this.firstNonGap() || indx > this.lastNonGap()) {
                return Alphabet.EMPTY_ALPHABET.getGapSymbol();
            }
            return this.getAlphabet().getGapSymbol();
        }
        try {
            Block b = (Block)this.blocks.get(i);
            return this.source.symbolAt(b.sourceStart - b.viewStart + indx);
        }
        catch (IndexOutOfBoundsException e) {
            throw new AssertionFailure("Internal book-keeping error fetching index: " + indx + " of " + this.length() + " blocks: " + this.blocks, e);
        }
    }

    public int firstNonGap() {
        int first = ((Block)this.blocks.get((int)0)).viewStart;
        return first;
    }

    public int lastNonGap() {
        int last = ((Block)this.blocks.get((int)(this.blocks.size() - 1))).viewEnd;
        return last;
    }

    public List BlockIterator() {
        return Collections.unmodifiableList(this.blocks);
    }

    public SimpleGappedSymbolList(SymbolList source) {
        this.source = source;
        this.alpha = source.getAlphabet();
        this.blocks = new ArrayList();
        this.length = source.length();
        Block b = new Block(1, this.length, 1, this.length);
        this.blocks.add(b);
    }

    public void dumpBlocks() {
        Iterator i = this.blocks.iterator();
        while (i.hasNext()) {
            Block b = (Block)i.next();
            System.out.println(b.sourceStart + ".." + b.sourceEnd + "\t" + b.viewStart + ".." + b.viewEnd);
        }
    }

    public Location locationToGapped(Location l) {
        if (l.isContiguous()) {
            return this.blockToGapped(l);
        }
        ArrayList<Location> lblocks = new ArrayList<Location>();
        Iterator i = l.blockIterator();
        while (i.hasNext()) {
            lblocks.add(this.blockToGapped((Location)i.next()));
        }
        return LocationTools.union(lblocks);
    }

    public Location gappedToLocation(Location l) {
        if (l.isContiguous()) {
            return this.gappedToBlock(l);
        }
        ArrayList<Location> lblocks = new ArrayList<Location>();
        Iterator i = l.blockIterator();
        while (i.hasNext()) {
            lblocks.add(this.gappedToBlock((Location)i.next()));
        }
        return LocationTools.union(lblocks);
    }

    private Location blockToGapped(Location l) {
        int start = l.getMin();
        int end = l.getMax();
        ArrayList<RangeLocation> lblocks = new ArrayList<RangeLocation>();
        while (start <= end) {
            int containingBlockIdx = this.findSourceBlock(start);
            Block containingBlock = (Block)this.blocks.get(containingBlockIdx);
            int gbstart = start - containingBlock.sourceStart + containingBlock.viewStart;
            int gbend = Math.min(end - start + gbstart, containingBlock.viewEnd);
            lblocks.add(new RangeLocation(gbstart, gbend));
            start = start + gbend - gbstart + 1;
        }
        return LocationTools.union(lblocks);
    }

    private Location gappedToBlock(Location l) {
        int start = l.getMin();
        int end = l.getMax();
        int startBlockI = this.findViewBlock(start);
        int endBlockI = this.findViewBlock(end);
        if (startBlockI < 0) {
            int sb = -startBlockI - 1;
            if (sb == this.blocks.size()) {
                start = Integer.MAX_VALUE;
            } else {
                Block startBlock = (Block)this.blocks.get(sb);
                start = startBlock.sourceStart;
            }
        } else {
            Block startBlock = (Block)this.blocks.get(startBlockI);
            start = start - startBlock.viewStart + startBlock.sourceStart;
        }
        if (endBlockI < 0) {
            int eb = -endBlockI - 1;
            if (eb == 0) {
                end = Integer.MIN_VALUE;
            } else {
                Block endBlock = (Block)this.blocks.get(eb - 1);
                end = endBlock.sourceEnd;
            }
        } else {
            Block endBlock = (Block)this.blocks.get(endBlockI);
            end = end - endBlock.viewEnd + endBlock.sourceEnd;
        }
        if (start > end) {
            return Location.empty;
        }
        return new RangeLocation(start, end);
    }

    public SymbolList getSourceSymbolList() {
        return this.source;
    }

    public Location getUngappedLocation() {
        ArrayList<RangeLocation> locList = new ArrayList<RangeLocation>(this.blocks.size());
        Iterator i = this.blocks.iterator();
        while (i.hasNext()) {
            Block block = (Block)i.next();
            locList.add(new RangeLocation(block.viewStart, block.viewEnd));
        }
        return LocationTools.union(locList);
    }

    protected boolean isSane() {
        Iterator i = this.blocks.iterator();
        while (i.hasNext()) {
            Block b = (Block)i.next();
            if (b.isSane()) continue;
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !SimpleGappedSymbolList.class.desiredAssertionStatus();
    }

    protected static final class Block
    implements Serializable {
        public int sourceStart;
        public int sourceEnd;
        public int viewStart;
        public int viewEnd;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Block(int sourceStart, int sourceEnd, int viewStart, int viewEnd) {
            this.sourceStart = sourceStart;
            this.sourceEnd = sourceEnd;
            this.viewStart = viewStart;
            this.viewEnd = viewEnd;
        }

        public Block(Block block) {
            this.sourceStart = block.sourceStart;
            this.sourceEnd = block.sourceEnd;
            this.viewStart = block.viewStart;
            this.viewEnd = block.viewEnd;
            if (!$assertionsDisabled && !this.isSane()) {
                throw new AssertionError((Object)("Block is a sane shape: " + this.toString()));
            }
        }

        public String toString() {
            return "Block: source=" + this.sourceStart + "," + this.sourceEnd + " view=" + this.viewStart + "," + this.viewEnd;
        }

        public boolean isSane() {
            return this.viewEnd - this.viewStart == this.sourceEnd - this.sourceStart;
        }

        static {
            $assertionsDisabled = !(class$org$biojava$bio$symbol$SimpleGappedSymbolList == null ? (class$org$biojava$bio$symbol$SimpleGappedSymbolList = SimpleGappedSymbolList.class$("org.biojava.bio.symbol.SimpleGappedSymbolList")) : class$org$biojava$bio$symbol$SimpleGappedSymbolList).desiredAssertionStatus();
        }
    }
}

