/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignmentPanel;
import jalview.DrawableSequence;
import jalview.ScorePanel;
import jalview.ScoreSequence;
import jalview.Sequence;
import java.awt.Component;
import java.awt.Event;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.util.Vector;

public class BigPanel
extends AlignmentPanel {
    Object parent;
    public ScorePanel scorePanel;
    Scrollbar hscroll;
    int maxoffx;
    int maxoffy;
    int offx;
    int offy;
    int width;
    int height;
    Panel p;

    public BigPanel(Component component, DrawableSequence[] drawableSequenceArray) {
        super(component, drawableSequenceArray);
        this.scorePanel = null;
        this.componentInit();
    }

    public BigPanel(Component component, DrawableSequence[] drawableSequenceArray, ScoreSequence[] scoreSequenceArray) {
        super(component, drawableSequenceArray);
        this.scorePanel = new ScorePanel(component, scoreSequenceArray);
        this.scorePanel = null;
        this.componentInit();
        System.out.println("Loaded BigPanel");
    }

    public void componentInit() {
        super.componentInit();
        this.hscroll = new Scrollbar(0);
        this.add(this.hscroll);
        this.setScrollValues(0, 0);
        if (this.scorePanel != null) {
            this.add(this.scorePanel);
            this.scorePanel.seqPanel.remove(this.scorePanel.seqPanel.hscroll);
        }
        this.seqPanel.remove(this.seqPanel.hscroll);
        System.out.println("Finished BigPanel.componentInit");
    }

    public ScoreSequence[] findScores(Sequence[] sequenceArray) {
        Vector<ScoreSequence> vector = new Vector<ScoreSequence>();
        int n = 0;
        while (n < sequenceArray.length && sequenceArray[n] != null) {
            int n2 = 0;
            while (n2 < sequenceArray[n].score.length && sequenceArray[n].score[n2] != null) {
                if (sequenceArray[n].score[n2].size() > 0) {
                    vector.addElement(new ScoreSequence(sequenceArray[n], n2));
                }
                ++n2;
            }
            ++n;
        }
        ScoreSequence[] scoreSequenceArray = new ScoreSequence[vector.size()];
        n = 0;
        while (n < vector.size()) {
            scoreSequenceArray[n] = (ScoreSequence)vector.elementAt(n);
            ++n;
        }
        return scoreSequenceArray;
    }

    public void setScorePanel(ScorePanel scorePanel) {
        this.scorePanel = scorePanel;
        scorePanel.seqPanel.remove(scorePanel.seqPanel.hscroll);
        this.add(this.scorePanel);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.oldreshape(n, n2, n3, n4);
        int n5 = 20;
        int n6 = this.idPanel.idCanvas.idWidth;
        int n7 = n4 - n5;
        if (this.scorePanel != null) {
            this.scorePanel.idPanel.idCanvas.idWidth = n6;
            int n8 = this.scorePanel.seqPanel.align.getHeight(0, this.scorePanel.seqPanel.align.size() - 1) + this.scorePanel.seqPanel.align.ds[this.scorePanel.seqPanel.align.size() - 1].charHeight + 20;
            int n9 = (this.seqPanel.align.size() + 1) * this.seqPanel.seqCanvas.charHeight;
            n7 = n8 < (n4 - n5) / 2 ? n4 - n5 - n8 : (n4 - n5) * n9 / (n8 + n9);
            if (this.scaleheight + (this.seqPanel.align.size() + 1) * this.seqPanel.seqCanvas.charHeight < n7) {
                n7 = (this.seqPanel.align.size() + 1) * this.seqPanel.seqCanvas.charHeight + this.scaleheight;
            }
            this.scorePanel.reshape(0, n7, n3, n4 - n7 - n5);
        }
        this.scalePanel.reshape(0, 0, n3, this.scaleheight);
        this.idPanel.reshape(0, this.scaleheight, n6, n7 - this.scaleheight);
        this.seqPanel.reshape(n6, this.scaleheight, n3 - n6, n7 - this.scaleheight);
        this.hscroll.reshape(0, n4 - n5, n3, n5);
        this.setScrollValues(this.offx, 0);
    }

    public void setScrollValues(int n, int n2) {
        this.seqPanel.invalidate();
        this.invalidate();
        this.validate();
        if (this.seqPanel.seqCanvas.size().width > 0) {
            this.width = this.seqPanel.seqCanvas.size().width;
            this.height = this.seqPanel.seqCanvas.size().height;
        } else {
            this.width = 700;
            this.height = 500;
        }
        if (this.maxoffx != this.seqPanel.align.maxLength() + 1) {
            this.maxoffx = this.seqPanel.align.maxLength() + 1;
        }
        this.hscroll.setValues(n, this.width / this.seqPanel.seqCanvas.charWidth, 0, this.maxoffx);
        this.hscroll.setLineIncrement(1);
        if (this.seqPanel.seqCanvas.endx > 0) {
            this.hscroll.setPageIncrement((this.seqPanel.seqCanvas.endx - this.seqPanel.seqCanvas.startx) / 2);
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                if (event.target != this.hscroll) break;
                this.seqPanel.offx = this.offx = this.hscroll.getValue();
                this.scalePanel.scaleCanvas.paintFlag = true;
                this.seqPanel.seqCanvas.repaint();
                this.scalePanel.scaleCanvas.repaint();
                if (this.scorePanel != null) {
                    this.scorePanel.seqPanel.offx = this.offx;
                    this.scorePanel.scalePanel.scaleCanvas.paintFlag = true;
                    this.scorePanel.seqPanel.seqCanvas.repaint();
                    this.scorePanel.scalePanel.scaleCanvas.repaint();
                }
                return true;
            }
        }
        return super.handleEvent(event);
    }
}

