/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.SQLDAOBaseImpl;
import uk.ac.sanger.jcon.dao.StatusSQLDAO;
import uk.ac.sanger.jcon.dao.TaskStatisticDAO;
import uk.ac.sanger.jcon.job.Status;
import uk.ac.sanger.jcon.job.TaskState;

public class TaskStatisticSQLDAO
extends SQLDAOBaseImpl
implements TaskStatisticDAO {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$dao$TaskStatisticSQLDAO == null ? (class$uk$ac$sanger$jcon$dao$TaskStatisticSQLDAO = TaskStatisticSQLDAO.class$("uk.ac.sanger.jcon.dao.TaskStatisticSQLDAO")) : class$uk$ac$sanger$jcon$dao$TaskStatisticSQLDAO).getName());
    static ResourceBundle sqlStatements = ResourceBundle.getBundle((class$uk$ac$sanger$jcon$dao$TaskStatisticSQLDAO == null ? (class$uk$ac$sanger$jcon$dao$TaskStatisticSQLDAO = TaskStatisticSQLDAO.class$("uk.ac.sanger.jcon.dao.TaskStatisticSQLDAO")) : class$uk$ac$sanger$jcon$dao$TaskStatisticSQLDAO).getName());
    private StatusSQLDAO statusSQLDAO = new StatusSQLDAO();
    static /* synthetic */ Class class$uk$ac$sanger$jcon$dao$TaskStatisticSQLDAO;

    public TaskStatisticSQLDAO() {
    }

    public TaskStatisticSQLDAO(DataSource datasource) {
        super(datasource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] readSubmittedTaskId() throws SQLException {
        String sql = sqlStatements.getString("readSubmittedTaskId");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        ArrayList<Integer> taskIds = new ArrayList<Integer>();
        int taskId = 0;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            cat.debug((Object)("Executing SQL: " + sql));
            r = ps.executeQuery();
            while (r.next()) {
                taskId = r.getInt("task_id");
                cat.debug((Object)("Submitted Task ID is " + taskId));
                taskIds.add(new Integer(taskId));
            }
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        int[] submittedTaskIds = new int[taskIds.size()];
        int i = 0;
        while (i < submittedTaskIds.length) {
            submittedTaskIds[i] = (Integer)taskIds.get(i);
            ++i;
        }
        return submittedTaskIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] readNSubmittedTaskId(int n) throws SQLException {
        String sql = sqlStatements.getString("readNSubmittedTaskId");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        int[] taskIds = new int[n];
        int rowCount = 0;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            cat.debug((Object)("Executing SQL: " + sql));
            r = ps.executeQuery();
            while (r.next() && rowCount < n) {
                int taskId;
                taskIds[rowCount] = taskId = r.getInt("task_id");
                ++rowCount;
            }
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        if (rowCount < n) {
            int[] actualIds = new int[rowCount];
            System.arraycopy(taskIds, 0, actualIds, 0, rowCount);
            taskIds = actualIds;
        }
        return taskIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] readSubmittedTaskIdByOwner(int ownerId) throws SQLException {
        String sql = sqlStatements.getString("readSubmittedTaskIdByOwner");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        ArrayList<Integer> taskIds = new ArrayList<Integer>();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, ownerId);
            cat.debug((Object)("Executing SQL: " + sql));
            r = ps.executeQuery();
            while (r.next()) {
                taskIds.add(new Integer(r.getInt("task_id")));
            }
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        int[] submittedTaskIds = new int[taskIds.size()];
        int i = 0;
        while (i < submittedTaskIds.length) {
            submittedTaskIds[i] = (Integer)taskIds.get(i);
            ++i;
        }
        return submittedTaskIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readSubmittedTaskState() throws SQLException, JobControlException {
        String sql = sqlStatements.getString("readSubmittedTaskState");
        Connection c = this.getManagedConnection();
        this.statusSQLDAO.setConnection(c);
        PreparedStatement ps = null;
        ResultSet r = null;
        Status status = null;
        HashMap<Integer, TaskState> tStats = new HashMap<Integer, TaskState>();
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            while (r.next()) {
                Integer taskId = new Integer(r.getInt("task_id"));
                cat.debug((Object)("Got statistic for Task [" + taskId.toString() + "]"));
                TaskState tStat = null;
                if (tStats.containsKey(taskId)) {
                    tStat = (TaskState)tStats.get(taskId);
                } else {
                    tStat = new TaskState(taskId);
                    cat.debug((Object)("Created TaskState [" + taskId + "]"));
                    tStats.put(taskId, tStat);
                }
                status = this.statusSQLDAO.readStatusById(r.getInt("status_id"));
                tStat.setJobCount(status, r.getInt("num_jobs"));
            }
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return tStats.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TaskState readTaskState(int taskId) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("readTaskState");
        Connection c = this.getManagedConnection();
        this.statusSQLDAO.setConnection(c);
        PreparedStatement ps = null;
        ResultSet r = null;
        Status status = null;
        TaskState tStat = new TaskState(taskId);
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, taskId);
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            while (r.next()) {
                status = this.statusSQLDAO.readStatusById(r.getInt("status_id"));
                tStat.setJobCount(status, r.getInt("num_jobs"));
            }
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return tStat;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

