/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.Connection;
import Freeze.DatabaseException;
import Freeze.LinkedList;
import Freeze.Map;
import Freeze.SharedDbEnv;
import Freeze.Transaction;
import Freeze.TransactionAlreadyInProgressException;
import Freeze.TransactionI;
import Ice.Communicator;
import Ice.LocalObjectImpl;
import Ice.Properties;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbTxn;
import java.util.Iterator;

class ConnectionI
extends LocalObjectImpl
implements Connection {
    private Communicator _communicator;
    private SharedDbEnv _dbEnvHolder;
    private DbEnv _dbEnv;
    private String _envName;
    private TransactionI _transaction;
    private LinkedList _mapList = new LinkedList();
    private int _trace;
    private boolean _deadlockWarning;
    private boolean _closeInFinalizeWarning;

    public Transaction beginTransaction() {
        if (this._transaction != null) {
            throw new TransactionAlreadyInProgressException();
        }
        this.closeAllIterators();
        this._transaction = new TransactionI(this);
        return this._transaction;
    }

    public Transaction currentTransaction() {
        return this._transaction;
    }

    public void close() {
        this.close(false);
    }

    public Communicator getCommunicator() {
        return this._communicator;
    }

    public String getName() {
        return this._envName;
    }

    protected void finalize() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean finalizing) {
        if (this._transaction != null) {
            if (finalizing) {
                this._communicator.getLogger().warning("Finalizing Connection on DbEnv \"" + this._envName + "\" with active transaction");
            }
            try {
                this._transaction.rollback();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            Iterator p = this._mapList.iterator();
            while (p.hasNext()) {
                ((Map)p.next()).close(finalizing);
            }
        }
        this._dbEnv = null;
        if (this._dbEnvHolder != null) {
            try {
                this._dbEnvHolder.close();
            }
            finally {
                this._dbEnvHolder = null;
            }
        }
    }

    ConnectionI(Communicator communicator, String envName) {
        this._communicator = communicator;
        this._dbEnvHolder = SharedDbEnv.get(communicator, envName);
        this._dbEnv = this._dbEnvHolder;
        this._envName = envName;
        this._trace = this._communicator.getProperties().getPropertyAsInt("Freeze.Trace.Map");
        Properties properties = this._communicator.getProperties();
        this._deadlockWarning = properties.getPropertyAsInt("Freeze.Warn.Deadlocks") > 0;
        this._closeInFinalizeWarning = properties.getPropertyAsIntWithDefault("Freeze.Warn.CloseInFinalize", 1) > 0;
    }

    ConnectionI(Communicator communicator, String envName, DbEnv dbEnv) {
        this._communicator = communicator;
        this._dbEnv = dbEnv;
        this._envName = envName;
        this._trace = this._communicator.getProperties().getPropertyAsInt("Freeze.Trace.Map");
    }

    synchronized void closeAllIterators() {
        Iterator p = this._mapList.iterator();
        while (p.hasNext()) {
            ((Map)p.next()).closeAllIterators();
        }
    }

    synchronized Iterator registerMap(Map map) {
        this._mapList.addFirst(map);
        Iterator p = this._mapList.iterator();
        p.next();
        return p;
    }

    synchronized void unregisterMap(Iterator p) {
        p.remove();
    }

    void clearTransaction() {
        this._transaction = null;
    }

    DbTxn dbTxn() {
        if (this._transaction == null) {
            return null;
        }
        return this._transaction.dbTxn();
    }

    DbEnv dbEnv() {
        return this._dbEnv;
    }

    String envName() {
        return this._envName;
    }

    Communicator communicator() {
        return this._communicator;
    }

    final int trace() {
        return this._trace;
    }

    final boolean deadlockWarning() {
        return this._deadlockWarning;
    }

    final boolean closeInFinalizeWarning() {
        return this._closeInFinalizeWarning;
    }
}

