/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.DatabaseException;
import Freeze.EvictorElement;
import Freeze.EvictorI;
import Freeze.Index;
import Freeze.NotFoundException;
import Freeze.ObjectRecord;
import Ice.Communicator;
import Ice.Identity;
import Ice.Util;
import IceInternal.BasicStream;
import IceUtil.Cache;
import IceUtil.Store;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbt;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

class ObjectStore
implements Store {
    private final Cache _cache = new Cache(this);
    private Db _db;
    private final String _facet;
    private final String _dbName;
    private final EvictorI _evictor;
    private final List _indices;
    private final Communicator _communicator;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ObjectStore(String facet, boolean createDb, EvictorI evictor, List indices, boolean populateEmptyIndices) {
        this._facet = facet;
        this._evictor = evictor;
        this._indices = indices;
        this._communicator = evictor.communicator();
        this._dbName = facet.equals("") ? "$default" : facet;
        DbTxn txn = null;
        DbEnv dbEnv = evictor.dbEnv();
        try {
            try {
                this._db = new Db(dbEnv, 0);
                txn = dbEnv.txn_begin(null, 0);
                int flags = 0;
                if (createDb) {
                    flags |= Db.DB_CREATE;
                }
                this._db.open(txn, evictor.filename(), this._dbName, 1, flags, 0);
                Iterator p = this._indices.iterator();
                while (p.hasNext()) {
                    Index index = (Index)p.next();
                    index.associate(this, txn, createDb, populateEmptyIndices);
                }
                DbTxn toCommit = txn;
                txn = null;
                toCommit.commit(0);
            }
            catch (FileNotFoundException dx) {
                NotFoundException ex = new NotFoundException();
                ex.initCause(dx);
                ex.message = this._evictor.errorPrefix() + "Db.open: " + dx.getMessage();
                throw ex;
            }
            catch (DbException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = this._evictor.errorPrefix() + "Db.open: " + dx.getMessage();
                throw ex;
            }
            Object var12_15 = null;
            if (txn == null) return;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (txn == null) throw throwable;
            try {
                txn.abort();
                throw throwable;
            }
            catch (DbException dx) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (DbException dx) {}
        txn.abort();
        return;
    }

    protected void finalize() {
        if (this._db != null) {
            this.close();
        }
    }

    void close() {
        try {
            this._db.close(0);
            Iterator p = this._indices.iterator();
            while (p.hasNext()) {
                Index index = (Index)p.next();
                index.close();
            }
            this._indices.clear();
        }
        catch (DbException dx) {
            DatabaseException ex = new DatabaseException();
            ex.initCause(dx);
            ex.message = this._evictor.errorPrefix() + "Db.close: " + dx.getMessage();
            throw ex;
        }
        this._db = null;
    }

    boolean dbHasObject(Identity ident) {
        byte[] key = ObjectStore.marshalKey(ident, this._communicator);
        Dbt dbKey = new Dbt(key);
        Dbt dbValue = new Dbt();
        dbValue.set_flags(Db.DB_DBT_PARTIAL);
        while (true) {
            try {
                int err = this._db.get(null, dbKey, dbValue, 0);
                if (err == 0) {
                    return true;
                }
                if (err == -30990) {
                    return false;
                }
                throw new DatabaseException();
            }
            catch (DbDeadlockException deadlock) {
                if (!this._evictor.deadlockWarning()) continue;
                this._communicator.getLogger().warning("Deadlock in Freeze.ObjectStore.dhHasObject while reading Db \"" + this._evictor.filename() + "/" + this._dbName + "\"; retrying ...");
                continue;
            }
            catch (DbException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = this._evictor.errorPrefix() + "Db.get: " + dx.getMessage();
                throw ex;
            }
            break;
        }
    }

    void save(byte[] key, byte[] value, byte status, DbTxn tx) throws DbException {
        switch (status) {
            case 1: 
            case 2: {
                Dbt dbKey = new Dbt(key);
                Dbt dbValue = new Dbt(value);
                int flags = status == 1 ? Db.DB_NOOVERWRITE : 0;
                int err = this._db.put(tx, dbKey, dbValue, flags);
                if (err == 0) break;
                throw new DatabaseException();
            }
            case 3: {
                Dbt dbKey = new Dbt(key);
                int err = this._db.del(tx, dbKey, 0);
                if (err == 0) break;
                throw new DatabaseException();
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshalKey(Identity v, Communicator communicator) {
        BasicStream os = new BasicStream(Util.getInstance(communicator));
        try {
            v.__write(os);
            ByteBuffer buf = os.prepareWrite();
            byte[] r = new byte[buf.limit()];
            buf.get(r);
            byte[] byArray = r;
            return byArray;
        }
        finally {
            os.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Identity unmarshalKey(byte[] b, Communicator communicator) {
        BasicStream is = new BasicStream(Util.getInstance(communicator));
        try {
            is.resize(b.length, true);
            ByteBuffer buf = is.prepareRead();
            buf.position(0);
            buf.put(b);
            buf.position(0);
            Identity key = new Identity();
            key.__read(is);
            Identity identity = key;
            return identity;
        }
        finally {
            is.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshalValue(ObjectRecord v, Communicator communicator) {
        BasicStream os = new BasicStream(Util.getInstance(communicator));
        try {
            os.startWriteEncaps();
            v.__write(os);
            os.writePendingObjects();
            os.endWriteEncaps();
            ByteBuffer buf = os.prepareWrite();
            byte[] r = new byte[buf.limit()];
            buf.get(r);
            byte[] byArray = r;
            return byArray;
        }
        finally {
            os.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectRecord unmarshalValue(byte[] b, Communicator communicator) {
        BasicStream is = new BasicStream(Util.getInstance(communicator));
        is.sliceObjects(false);
        try {
            is.resize(b.length, true);
            ByteBuffer buf = is.prepareRead();
            buf.position(0);
            buf.put(b);
            buf.position(0);
            ObjectRecord rec = new ObjectRecord();
            is.startReadEncaps();
            rec.__read(is);
            is.readPendingObjects();
            is.endReadEncaps();
            ObjectRecord objectRecord = rec;
            return objectRecord;
        }
        finally {
            is.destroy();
        }
    }

    final Cache cache() {
        return this._cache;
    }

    final Db db() {
        return this._db;
    }

    final Communicator communicator() {
        return this._communicator;
    }

    final EvictorI evictor() {
        return this._evictor;
    }

    final String facet() {
        return this._facet;
    }

    final String dbName() {
        return this._dbName;
    }

    public Object load(Object identObj) {
        Identity ident = (Identity)identObj;
        byte[] key = ObjectStore.marshalKey(ident, this._communicator);
        Dbt dbKey = new Dbt(key);
        Dbt dbValue = new Dbt();
        while (true) {
            try {
                int rs = this._db.get(null, dbKey, dbValue, 0);
                if (rs == -30990) {
                    return null;
                }
                if (rs != 0) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    throw new DatabaseException();
                }
            }
            catch (DbDeadlockException deadlock) {
                if (!this._evictor.deadlockWarning()) continue;
                this._communicator.getLogger().warning("Deadlock in Freeze.ObjectStore.load while reading Db \"" + this._evictor.filename() + "/" + this._dbName + "\"; retrying ...");
                continue;
            }
            catch (DbException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = this._evictor.errorPrefix() + "Db.get: " + dx.getMessage();
                throw ex;
            }
            break;
        }
        EvictorElement result = new EvictorElement(ident, this);
        result.rec = ObjectStore.unmarshalValue(dbValue.get_data(), this._communicator);
        this._evictor.initialize(ident, this._facet, result.rec.servant);
        return result;
    }

    static {
        $assertionsDisabled = !ObjectStore.class.desiredAssertionStatus();
    }
}

