/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.LocalException;
import Ice.Properties;
import Ice.StringSeqHolder;
import Ice.Util;

public abstract class Application {
    private static String _appName;
    private static Communicator _communicator;
    private static DestroyHook _destroyHook;
    private static ShutdownHook _shutdownHook;
    private static boolean _interrupted;

    public Application() {
        _interrupted = false;
    }

    public final int main(String appName, String[] args) {
        return this.main(appName, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int main(String appName, String[] args, String configFile) {
        if (_communicator != null) {
            System.err.println(appName + ": only one instance of the Application class can be used");
            return 1;
        }
        _appName = appName;
        int status = 0;
        try {
            StringSeqHolder argHolder = new StringSeqHolder(args);
            if (configFile != null) {
                Properties properties = Util.createProperties(argHolder);
                properties.load(configFile);
                _communicator = Util.initializeWithProperties(argHolder, properties);
            } else {
                _communicator = Util.initialize(argHolder);
            }
            Application.destroyOnInterrupt();
            status = this.run(argHolder.value);
        }
        catch (LocalException ex) {
            System.err.println(_appName + ": " + ex);
            ex.printStackTrace();
            status = 1;
        }
        catch (Exception ex) {
            System.err.println(_appName + ": unknown exception");
            ex.printStackTrace();
            status = 1;
        }
        if (_communicator != null) {
            try {
                _communicator.destroy();
            }
            catch (LocalException ex) {
                System.err.println(_appName + ": " + ex);
                ex.printStackTrace();
                status = 1;
            }
            catch (Exception ex) {
                System.err.println(_appName + ": unknown exception");
                ex.printStackTrace();
                status = 1;
            }
            _communicator = null;
        }
        Application application = this;
        synchronized (application) {
            if (_destroyHook != null) {
                _destroyHook.done();
            }
            if (_shutdownHook != null) {
                _shutdownHook.done();
            }
        }
        return status;
    }

    public abstract int run(String[] var1);

    public static String appName() {
        return _appName;
    }

    public static Communicator communicator() {
        return _communicator;
    }

    public static synchronized void destroyOnInterrupt() {
        block6: {
            if (_shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(_shutdownHook);
                    _shutdownHook = null;
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
            }
            if (_destroyHook == null) {
                _destroyHook = new DestroyHook();
                try {
                    Runtime.getRuntime().addShutdownHook(_destroyHook);
                }
                catch (IllegalStateException ex) {
                    if (_communicator == null) break block6;
                    _communicator.destroy();
                }
            }
        }
    }

    public static synchronized void shutdownOnInterrupt() {
        block6: {
            if (_destroyHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(_destroyHook);
                    _destroyHook = null;
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
            }
            if (_shutdownHook == null) {
                _shutdownHook = new ShutdownHook();
                try {
                    Runtime.getRuntime().addShutdownHook(_shutdownHook);
                }
                catch (IllegalStateException ex) {
                    if (_communicator == null) break block6;
                    _communicator.shutdown();
                }
            }
        }
    }

    public static synchronized void defaultInterrupt() {
        if (_shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(_shutdownHook);
                _shutdownHook = null;
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
        }
        if (_destroyHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(_destroyHook);
                _destroyHook = null;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static synchronized boolean interrupted() {
        return _interrupted;
    }

    private static synchronized void setInterrupt() {
        _interrupted = true;
    }

    static class ShutdownHook
    extends Thread {
        private boolean _done = false;
        private Object _doneMutex = new Object();

        ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this._doneMutex;
            synchronized (object) {
                Application.setInterrupt();
                Communicator communicator = Application.communicator();
                if (communicator != null) {
                    communicator.shutdown();
                }
                while (!this._done) {
                    try {
                        this._doneMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done() {
            Object object = this._doneMutex;
            synchronized (object) {
                this._done = true;
                this._doneMutex.notify();
            }
        }
    }

    static class DestroyHook
    extends Thread {
        private boolean _done = false;
        private Object _doneMutex = new Object();

        DestroyHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this._doneMutex;
            synchronized (object) {
                Application.setInterrupt();
                Communicator communicator = Application.communicator();
                if (communicator != null) {
                    communicator.destroy();
                }
                while (!this._done) {
                    try {
                        this._doneMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done() {
            Object object = this._doneMutex;
            synchronized (object) {
                this._done = true;
                this._doneMutex.notify();
            }
        }
    }
}

