/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.CommunicatorI;
import Ice.Identity;
import Ice.IdentityParseException;
import Ice.ObjectPrx;
import Ice.Properties;
import Ice.PropertiesI;
import Ice.StringHolder;
import Ice.StringSeqHolder;
import IceInternal.Instance;
import IceInternal.Network;
import IceUtil.StringUtil;
import java.net.InetAddress;
import java.rmi.server.UID;

public final class Util {
    private static Properties _defaultProperties = null;
    private static String _localAddress = null;

    public static Properties createProperties() {
        return new PropertiesI();
    }

    public static Properties createProperties(StringSeqHolder args) {
        return new PropertiesI(args);
    }

    public static Properties createProperties(String[] args) {
        StringSeqHolder argsH = new StringSeqHolder(args);
        return Util.createProperties(argsH);
    }

    public static Properties getDefaultProperties() {
        if (_defaultProperties == null) {
            _defaultProperties = Util.createProperties();
        }
        return _defaultProperties;
    }

    public static Properties getDefaultProperties(StringSeqHolder args) {
        if (_defaultProperties == null) {
            _defaultProperties = Util.createProperties(args);
        }
        return _defaultProperties;
    }

    public static Properties getDefaultProperties(String[] args) {
        StringSeqHolder argsH = new StringSeqHolder(args);
        return Util.getDefaultProperties(argsH);
    }

    public static Communicator initialize(StringSeqHolder args) {
        Properties properties = Util.getDefaultProperties(args);
        return Util.initializeWithProperties(args, properties);
    }

    public static Communicator initialize(String[] args) {
        StringSeqHolder argsH = new StringSeqHolder(args);
        return Util.initialize(argsH);
    }

    public static Communicator initializeWithProperties(StringSeqHolder args, Properties properties) {
        CommunicatorI result = new CommunicatorI(properties);
        result.finishSetup(args);
        return result;
    }

    public static Communicator initializeWithProperties(String[] args, Properties properties) {
        StringSeqHolder argsH = new StringSeqHolder(args);
        return Util.initializeWithProperties(argsH, properties);
    }

    public static Instance getInstance(Communicator communicator) {
        CommunicatorI p = (CommunicatorI)communicator;
        return p.getInstance();
    }

    public static Identity stringToIdentity(String s) {
        Identity ident = new Identity();
        int slash = -1;
        int pos = 0;
        while ((pos = s.indexOf(47, pos)) != -1) {
            if (pos == 0 || s.charAt(pos - 1) != '\\') {
                if (slash == -1) {
                    slash = pos;
                } else {
                    IdentityParseException ex = new IdentityParseException();
                    ex.str = s;
                    throw ex;
                }
            }
            ++pos;
        }
        if (slash == -1) {
            StringHolder token = new StringHolder();
            if (!StringUtil.unescapeString(s, 0, s.length(), token)) {
                IdentityParseException ex = new IdentityParseException();
                ex.str = s;
                throw ex;
            }
            ident.category = "";
            ident.name = token.value;
        } else {
            StringHolder token = new StringHolder();
            if (!StringUtil.unescapeString(s, 0, slash, token)) {
                IdentityParseException ex = new IdentityParseException();
                ex.str = s;
                throw ex;
            }
            ident.category = token.value;
            if (slash + 1 < s.length()) {
                if (!StringUtil.unescapeString(s, slash + 1, s.length(), token)) {
                    IdentityParseException ex = new IdentityParseException();
                    ex.str = s;
                    throw ex;
                }
                ident.name = token.value;
            } else {
                ident.name = "";
            }
        }
        return ident;
    }

    public static String identityToString(Identity ident) {
        if (ident.category.length() == 0) {
            return StringUtil.escapeString(ident.name, "/");
        }
        return StringUtil.escapeString(ident.category, "/") + '/' + StringUtil.escapeString(ident.name, "/");
    }

    public static synchronized String generateUUID() {
        UID uid = new UID();
        if (_localAddress == null) {
            InetAddress addr = Network.getLocalAddress();
            byte[] ip = addr.getAddress();
            _localAddress = "";
            for (int i = 0; i < ip.length; ++i) {
                if (i > 0) {
                    _localAddress = _localAddress + ":";
                }
                int n = ip[i] < 0 ? ip[i] + 256 : ip[i];
                _localAddress = _localAddress + Integer.toHexString(n);
            }
        }
        return _localAddress + ":" + uid;
    }

    public static int proxyIdentityCompare(ObjectPrx lhs, ObjectPrx rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null && rhs != null) {
            return -1;
        }
        if (lhs != null && rhs == null) {
            return 1;
        }
        Identity lhsIdentity = lhs.ice_getIdentity();
        Identity rhsIdentity = rhs.ice_getIdentity();
        int n = lhsIdentity.name.compareTo(rhsIdentity.name);
        if (n != 0) {
            return n;
        }
        return lhsIdentity.category.compareTo(rhsIdentity.category);
    }

    public static int proxyIdentityAndFacetCompare(ObjectPrx lhs, ObjectPrx rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null && rhs != null) {
            return -1;
        }
        if (lhs != null && rhs == null) {
            return 1;
        }
        Identity lhsIdentity = lhs.ice_getIdentity();
        Identity rhsIdentity = rhs.ice_getIdentity();
        int n = lhsIdentity.name.compareTo(rhsIdentity.name);
        if (n != 0) {
            return n;
        }
        n = lhsIdentity.category.compareTo(rhsIdentity.category);
        if (n != 0) {
            return n;
        }
        String lhsFacet = lhs.ice_getFacet();
        String rhsFacet = rhs.ice_getFacet();
        if (lhsFacet == null && rhsFacet == null) {
            return 0;
        }
        if (lhsFacet == null) {
            return -1;
        }
        if (rhsFacet == null) {
            return 1;
        }
        return lhsFacet.compareTo(rhsFacet);
    }
}

